/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.model.QADatasource;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qa/datasource"})
public class QADataManagerController {
    @Autowired
    private QADatasourceService datasourceService;

    @GetMapping(value={"/detail"})
    public ApiResponse<QADatasource> detail(@ApiParam(value="\u6570\u636e\u6e90id") @RequestParam(value="dbId") String dbId) {
        QADataSourceDto sysDataSourceDto = this.datasourceService.getDataSourceById(Long.valueOf(dbId));
        return ApiResponse.success((Object)((Object)sysDataSourceDto));
    }

    @GetMapping(value={"/getList"})
    public ApiResponse<IPage<QADatasource>> queryList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<QADatasource> page, @ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") QADatasource sysDataSource) {
        return ApiResponse.success(this.datasourceService.listDataSource(page, sysDataSource));
    }

    @PostMapping(value={"/edit"})
    public ApiResponse<QADatasource> edit(@ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") @RequestBody QADataSourceDto sysDatasource) {
        return ApiResponse.success((Object)((Object)this.datasourceService.updateDatasource(sysDatasource)));
    }

    @PostMapping(value={"/remove"})
    public ApiResponse<QADatasource> remove(@ApiParam(value="\u6570\u636e\u6e90id") @RequestBody List<String> ids) {
        this.datasourceService.deleteDataSource(ids);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/checkSource"})
    public ApiResponse<QADatasource> checkSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") @RequestBody QADataSourceDto sysDataSource) {
        return this.datasourceService.saveDataSourceWithCheck(sysDataSource, true);
    }

    @GetMapping(value={"/checkSourceById"})
    public ApiResponse<Boolean> checkSourceById(@RequestParam Long dbId) {
        return this.datasourceService.checkDataSourceById(dbId);
    }

    @PostMapping(value={"/save"})
    public ApiResponse<QADatasource> checkDataSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") @RequestBody QADataSourceDto sysDataSource) {
        return this.datasourceService.saveDataSourceWithCheck(sysDataSource, false);
    }

    @GetMapping(value={"/findAll"})
    public ApiResponse<List<QADatasource>> findAll() {
        return ApiResponse.success((Object)this.datasourceService.list());
    }
}

