/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dialogue.util.pdfUtil;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.ai.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.ai.attachment.service.BaseAttachmentManagerService;
import com.jxdinfo.hussar.common.util.IqaLibreOfficePDFConvert;
import com.jxdinfo.hussar.common.util.IqaSpringContextUtils;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaCadUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaCebUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaExcelUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaExceptionUtils;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaffmpegUtil;
import com.jxdinfo.hussar.dialogue.dao.KgDocManagementMapper;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.VideoInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public class changeToPdfThread
extends Thread {
    public static final Logger LOGGER = LogManager.getLogger(changeToPdfThread.class);
    private static ApplicationContext appCtx = IqaSpringContextUtils.getApplicationContext();
    private KgDocManagementMapper kgDocManagementMapper = (KgDocManagementMapper)appCtx.getBean(KgDocManagementMapper.class);
    private BaseAttachmentManagerService baseAttachmentManagerService = (BaseAttachmentManagerService)appCtx.getBean(BaseAttachmentManagerService.class);
    private String docId = "";
    private Boolean isUpload = true;
    private String dirPath;

    public changeToPdfThread(Boolean isUpload, String docId, String dirPath) {
        this.isUpload = isUpload;
        this.docId = docId;
        this.dirPath = dirPath;
    }

    public changeToPdfThread(String docId) {
        this.docId = docId;
    }

    @Override
    public void run() {
        block20: {
            LOGGER.info("******************\u6d4b\u8bd5:\u8fdb\u5165ChangeToPdfThread\u7ebf\u7a0b******************");
            List fileList = this.kgDocManagementMapper.getFileInfoByFileId(this.docId);
            if (fileList.size() > 0) {
                Map firMap = (Map)fileList.get(0);
                File sourceFile = null;
                String sourceFilePath = firMap.get("attachmentDir").toString() + firMap.get("id").toString() + "." + firMap.get("attachmentType").toString();
                if (!this.isUpload.booleanValue()) {
                    sourceFilePath = this.dirPath;
                }
                try {
                    sourceFile = new File(sourceFilePath);
                    if (!sourceFile.getParentFile().exists()) {
                        sourceFile.getParentFile().mkdirs();
                    }
                    if (!sourceFile.exists()) {
                        sourceFile.createNewFile();
                    }
                    String pdfFilePath = sourceFilePath.substring(0, sourceFilePath.lastIndexOf(".")) + ".pdf";
                    if (!this.isUpload.booleanValue()) {
                        pdfFilePath = String.valueOf(Paths.get(firMap.get("attachmentDir").toString() + firMap.get("id").toString() + ".pdf", new String[0]));
                    }
                    String sourceName = firMap.get("attachmentName").toString();
                    File pdfFile = null;
                    if (!sourceFile.exists()) break block20;
                    pdfFile = new File(pdfFilePath);
                    MagicMatch match = Magic.getMagicMatch((File)sourceFile, (boolean)false);
                    String contentType = match.getMimeType();
                    if (sourceName.endsWith(".ceb")) {
                        IqaCebUtil.ceb2Pdf((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("cad")) {
                        IqaCadUtil.cad2Pdf((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("word") || contentType.contains("rtf") || contentType.contains("works")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("text/html") && (sourceName.endsWith(".doc") || sourceName.endsWith(".docx"))) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                        IqaExcelUtil.changeExcel((String)sourceName);
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourceName.endsWith(".txt")) {
                        String type = changeToPdfThread.getFilecharset(sourceFile);
                        if (type.equals("GBK") || type.equals("ANSI")) {
                            String str = FileUtils.readFileToString((File)sourceFile, (String)"GBK");
                            FileUtils.writeStringToFile((File)sourceFile, (String)str, (String)"UTF-8");
                        }
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("octet-stream") && sourceName.endsWith(".tif")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre((File)sourceFile, (File)pdfFile);
                        break block20;
                    }
                    if (contentType.contains("mp4") || contentType.contains("avi") || contentType.contains("wmv") || contentType.contains("mpg") || contentType.contains("mpeg") || contentType.contains("mov") || contentType.contains("swf") || contentType.contains("flv") || contentType.contains("ram") || contentType.contains("rm")) {
                        LOGGER.info("==========\u51c6\u5907\u89c6\u9891\u8f6c\u6362===========");
                        Encoder encoder = new Encoder();
                        MultimediaInfo info = encoder.getInfo(sourceFile);
                        VideoInfo video = info.getVideo();
                        String decoder = video.getDecoder();
                        if (!decoder.equals("h264") || contentType.contains("mov")) {
                            LOGGER.info("==========\u89c6\u9891\u5f00\u59cb\u8f6c\u6362===========");
                            pdfFilePath = sourceName.substring(0, sourceName.lastIndexOf(".")) + "_new.mp4";
                            IqaffmpegUtil.convetor((String)sourceName, (String)pdfFilePath);
                            if (!changeToPdfThread.checkIsEmpty(pdfFilePath) && !(pdfFile = new File(pdfFilePath)).getParentFile().exists()) {
                                LOGGER.info("==========\u89c6\u9891===\u8def\u5f84\u4e0d\u5b58\u5728===========");
                                pdfFile.getParentFile().mkdirs();
                            }
                        }
                        break block20;
                    }
                    LOGGER.info("==========\u6682\u4e0d\u652f\u6301\u8f6c\u6362===========");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AttachmentManagerModel::getId, (Object)this.docId)).set(AttachmentManagerModel::getDelFlag, (Object)"9");
                    this.baseAttachmentManagerService.update((Wrapper)wrapper);
                    LOGGER.error("\u8f6c\u5316PDF\u5931\u8d25\uff1a" + IqaExceptionUtils.getErrorInfo((Exception)e));
                }
            } else {
                LOGGER.info("******************\u8f6c\u6362\u5931\u8d25:\u672a\u627e\u5230\u4e1a\u52a1id\u4e3a" + this.docId + "\u7684\u6570\u636e******************");
            }
        }
    }

    private static String getFilecharset(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }
}

