/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.util;

import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryBusiness;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.core.exception.HussarException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final String[] nodeHeaders = new String[]{"\u5e8f\u53f7\uff08\u5fc5\u586b\uff09", "\u8282\u70b9\u540d\u79f0\uff08\u5fc5\u586b\uff09", "\u8282\u70b9\u6807\u8bc6", "\u540c\u4e49\u8bcd\uff08\u591a\u4e2a\u540c\u4e49\u8bcd\u7528`\uff0c`\u9694\u5f00\uff09", "             \u63cf\u8ff0             ", "\u63cf\u8ff0\u4e2d\u7684\u5173\u952e\u8bcd\uff08\u591a\u4e2a\u5173\u952e\u8bcd\u7528`\uff0c`\u9694\u5f00\uff09"};
    private static final String[] businessHeaders = new String[]{" \u4e1a\u52a1\u540d\u79f0\uff08\u5fc5\u586b\uff09 ", "\u540c\u4e49\u8bcd\uff08\u591a\u4e2a\u540c\u4e49\u8bcd\u7528`\uff0c`\u9694\u5f00\uff09"};
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static CellStyle createHeaderCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        style.setFont(font);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public static void createHeaderRow(Row row, String[] headers, CellStyle style) {
        for (int i = 0; i < headers.length; ++i) {
            row.createCell(i).setCellValue(headers[i]);
            row.getCell(i).setCellStyle(style);
            row.getSheet().setColumnWidth(i, headers[i].length() * 600);
        }
    }

    public static boolean checkHeader(Row row, String[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            if (row.getCell(i) == null) {
                return false;
            }
            if (headers[i].trim().equals(ExcelUtil.getCellStringValue(row.getCell(i)))) continue;
            return false;
        }
        return true;
    }

    public static void exportExcel(HttpServletResponse response, Directory directory) {
        List<DirectoryNode> flatList = directory.getChildren();
        try (XSSFWorkbook workbook = new XSSFWorkbook();
             ServletOutputStream outputStream = response.getOutputStream();){
            Sheet sheet = workbook.createSheet("\u8282\u70b9\u8868");
            Row nodeHeaderRow = sheet.createRow(0);
            ExcelUtil.createHeaderRow(nodeHeaderRow, nodeHeaders, ExcelUtil.createHeaderCellStyle((Workbook)workbook));
            if (flatList != null) {
                for (int i = 0; i < flatList.size(); ++i) {
                    DirectoryNode directoryNode = flatList.get(i);
                    Row row = sheet.createRow(i + 1);
                    row.createCell(0).setCellValue(directoryNode.getOrdinal());
                    row.createCell(1).setCellValue(directoryNode.getNodeName());
                    row.createCell(2).setCellValue(directoryNode.getNodeKey());
                    row.createCell(3).setCellValue(directoryNode.getThesaurus());
                    row.createCell(4).setCellValue(directoryNode.getExplanation());
                    row.createCell(5).setCellValue(directoryNode.getThesaurusByExplanation());
                }
            }
            Sheet businessSheet = workbook.createSheet("\u4e1a\u52a1\u8bcd\u8868");
            Row businessHeaderRow = businessSheet.createRow(0);
            ExcelUtil.createHeaderRow(businessHeaderRow, businessHeaders, ExcelUtil.createHeaderCellStyle((Workbook)workbook));
            List<DirectoryBusiness> businessList = directory.getBusinessList();
            if (businessList != null) {
                for (int i = 0; i < businessList.size(); ++i) {
                    DirectoryBusiness directoryBusiness = businessList.get(i);
                    Row row = businessSheet.createRow(i + 1);
                    row.createCell(0).setCellValue(directoryBusiness.getBusinessName());
                    row.createCell(1).setCellValue(directoryBusiness.getThesaurus());
                }
            }
            response.reset();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(directory.getDirectoryName() + ".xlsx", "utf-8"));
            response.setStatus(200);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5bfc\u51faExcel\u5931\u8d25", e);
        }
    }

    public static void importDirectoryFromExcel(MultipartFile file, Directory directory) throws IOException {
        Long directoryId = directory.getDirectoryId();
        XSSFWorkbook workbook = null;
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(file.getContentType())) {
            workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
        } else if ("application/vnd.ms-excel".equals(file.getContentType())) {
            workbook = new HSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
        }
        int sheetCount = 0;
        if (workbook != null) {
            sheetCount = workbook.getNumberOfSheets();
        }
        if (sheetCount == 0) {
            throw new HussarException("Excel \u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
        }
        int nodeSheetIndex = -1;
        int businessSheetIndex = -1;
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            Row headerRow = sheet.getRow(0);
            if (headerRow.getRowNum() != 0) continue;
            if (nodeSheetIndex == -1 && ExcelUtil.checkHeader(headerRow, nodeHeaders)) {
                nodeSheetIndex = i;
            }
            if (businessSheetIndex != -1 || !ExcelUtil.checkHeader(headerRow, businessHeaders)) continue;
            businessSheetIndex = i;
        }
        if (nodeSheetIndex == -1) {
            throw new HussarException("Excel \u6587\u4ef6\u4e2d\u6ca1\u6709\u8282\u70b9\u8868\uff01");
        }
        ArrayList<Integer> emptyOrdinalList = new ArrayList<Integer>();
        ArrayList<Integer> emptyNodeNameList = new ArrayList<Integer>();
        ArrayList<Integer> emptyBusinessNameList = new ArrayList<Integer>();
        ArrayList<DirectoryNode> directoryNodeList = new ArrayList<DirectoryNode>();
        Sheet nodeSheet = workbook.getSheetAt(nodeSheetIndex);
        for (int i = 1; i < nodeSheet.getPhysicalNumberOfRows(); ++i) {
            Row row = nodeSheet.getRow(i);
            DirectoryNode directoryNode = new DirectoryNode();
            if (row.getCell(0) == null || ExcelUtil.getCellStringValue(row.getCell(0)).isEmpty()) {
                emptyOrdinalList.add(i + 1);
                continue;
            }
            if (row.getCell(1) == null || ExcelUtil.getCellStringValue(row.getCell(1)).isEmpty()) {
                emptyNodeNameList.add(i + 1);
                continue;
            }
            String ordinal = ExcelUtil.getCellStringValue(row.getCell(0)).replace(" ", "");
            int lastDotIndex = ordinal.lastIndexOf(".");
            int sortOrder = Integer.parseInt(ordinal.substring(lastDotIndex + 1));
            directoryNode.setOrdinal(ordinal);
            directoryNode.setSortOrder(sortOrder);
            directoryNode.setNodeName(ExcelUtil.getCellStringValue(row.getCell(1)));
            directoryNode.setNodeKey(ExcelUtil.getCellStringValue(row.getCell(2)));
            directoryNode.setThesaurus(ExcelUtil.getCellStringValue(row.getCell(3)));
            directoryNode.setExplanation(ExcelUtil.getCellStringValue(row.getCell(4)));
            directoryNode.setThesaurusByExplanation(ExcelUtil.getCellStringValue(row.getCell(5)));
            directoryNode.setDirectoryId(directoryId);
            directoryNodeList.add(directoryNode);
        }
        directory.setChildren(directoryNodeList);
        if (businessSheetIndex == -1) {
            if (!emptyOrdinalList.isEmpty() || !emptyNodeNameList.isEmpty()) {
                throw new HussarException(ExcelUtil.readExcelError(emptyOrdinalList, emptyNodeNameList, emptyBusinessNameList));
            }
            return;
        }
        ArrayList<DirectoryBusiness> directoryBusinessList = new ArrayList<DirectoryBusiness>();
        Sheet thesaurusSheet = workbook.getSheetAt(businessSheetIndex);
        for (int i = 1; i < thesaurusSheet.getPhysicalNumberOfRows(); ++i) {
            Row row = thesaurusSheet.getRow(i);
            DirectoryBusiness directoryBusiness = new DirectoryBusiness();
            if (row.getCell(0) == null || ExcelUtil.getCellStringValue(row.getCell(0)).isEmpty()) {
                emptyBusinessNameList.add(i + 1);
                continue;
            }
            directoryBusiness.setBusinessName(ExcelUtil.getCellStringValue(row.getCell(0)));
            directoryBusiness.setThesaurus(ExcelUtil.getCellStringValue(row.getCell(1)));
            directoryBusiness.setDirectoryId(directoryId);
            directoryBusinessList.add(directoryBusiness);
        }
        directory.setBusinessList(directoryBusinessList);
        if (!(emptyOrdinalList.isEmpty() && emptyNodeNameList.isEmpty() && emptyBusinessNameList.isEmpty())) {
            throw new HussarException(ExcelUtil.readExcelError(emptyOrdinalList, emptyNodeNameList, emptyBusinessNameList));
        }
    }

    public static String readExcelError(List<Integer> emptyOrdinalList, List<Integer> emptyNodeNameList, List<Integer> emptyBusinessNameList) {
        StringBuilder error = new StringBuilder();
        if (!emptyOrdinalList.isEmpty()) {
            error.append("\u8282\u70b9\u8868\u4e2d\u4ee5\u4e0b\u884c\u7684\u5e8f\u53f7\u4e3a\u7a7a\uff1a");
            for (Integer i : emptyOrdinalList) {
                error.append(i).append("\u3001");
            }
            error.deleteCharAt(error.length() - 1);
            error.append("\n");
        }
        if (!emptyNodeNameList.isEmpty()) {
            error.append("\u8282\u70b9\u8868\u4e2d\u4ee5\u4e0b\u884c\u7684\u8282\u70b9\u540d\u79f0\u4e3a\u7a7a\uff1a");
            for (Integer i : emptyNodeNameList) {
                error.append(i).append("\u3001");
            }
            error.deleteCharAt(error.length() - 1);
            error.append("\n");
        }
        if (!emptyBusinessNameList.isEmpty()) {
            error.append("\u4e1a\u52a1\u8bcd\u8868\u4e2d\u4ee5\u4e0b\u884c\u7684\u4e1a\u52a1\u540d\u79f0\u4e3a\u7a7a\uff1a");
            for (Integer i : emptyBusinessNameList) {
                error.append(i).append("\u3001");
            }
            error.deleteCharAt(error.length() - 1);
            error.append("\n");
        }
        return error.toString();
    }

    public static String getCellStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            String numericValue = String.valueOf(cell.getNumericCellValue());
            if (numericValue.endsWith(".0")) {
                return numericValue.substring(0, numericValue.length() - 2);
            }
            return numericValue;
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue().trim();
        }
        return "";
    }

    @Deprecated
    public static void exportLeafNodesToExcel(HttpServletResponse response, String directoryName, List<DirectoryNode> leafNodes) {
        OutputStream outputStream = null;
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("Sheet1");
            Row nodeHeaderRow = sheet.createRow(0);
            ExcelUtil.createHeaderRow(nodeHeaderRow, new String[]{"\u8282\u70b9\u540d\u79f0", "\u8282\u70b9\u6807\u8bc6", "\u8282\u70b9\u5168\u8def\u5f84"}, ExcelUtil.createHeaderCellStyle((Workbook)workbook));
            for (int i = 0; i < leafNodes.size(); ++i) {
                DirectoryNode directoryNode = leafNodes.get(i);
                Row row = sheet.createRow(i + 1);
                row.createCell(0).setCellValue(directoryNode.getNodeName());
                row.createCell(1).setCellValue(directoryNode.getNodeKey());
                row.createCell(2).setCellValue(directoryNode.getFullNamePath());
            }
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=\"" + URLEncoder.encode(directoryName + "\u53f6\u5b50\u8282\u70b9.xlsx", "utf-8") + "\"");
            response.setStatus(200);
            outputStream = response.getOutputStream();
            workbook.write(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5bfc\u51faExcel\u5931\u8d25", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }
}

