/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import java.util.Optional;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CollectionOptions {
    @Nullable
    private Long maxDocuments;
    @Nullable
    private Long size;
    @Nullable
    private Boolean capped;
    @Nullable
    private Collation collation;
    private ValidationOptions validationOptions;

    @Deprecated
    public CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped) {
        this(size, maxDocuments, capped, null, ValidationOptions.none());
    }

    private CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped, @Nullable Collation collation, ValidationOptions validationOptions) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
        this.validationOptions = validationOptions;
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, (String)"Collation must not be null!");
        return new CollectionOptions(null, null, null, collation, ValidationOptions.none());
    }

    public static CollectionOptions empty() {
        return new CollectionOptions(null, null, null, null, ValidationOptions.none());
    }

    public CollectionOptions capped() {
        return new CollectionOptions(this.size, this.maxDocuments, true, this.collation, this.validationOptions);
    }

    public CollectionOptions maxDocuments(long maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation, this.validationOptions);
    }

    public CollectionOptions size(long size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation, this.validationOptions);
    }

    public CollectionOptions collation(@Nullable Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, collation, this.validationOptions);
    }

    public CollectionOptions schema(@Nullable MongoJsonSchema schema) {
        return this.validator(Validator.schema(schema));
    }

    public CollectionOptions validator(@Nullable Validator validator) {
        return this.validation(this.validationOptions.validator(validator));
    }

    public CollectionOptions disableValidation() {
        return this.schemaValidationLevel(ValidationLevel.OFF);
    }

    public CollectionOptions strictValidation() {
        return this.schemaValidationLevel(ValidationLevel.STRICT);
    }

    public CollectionOptions moderateValidation() {
        return this.schemaValidationLevel(ValidationLevel.MODERATE);
    }

    public CollectionOptions warnOnValidationError() {
        return this.schemaValidationAction(ValidationAction.WARN);
    }

    public CollectionOptions failOnValidationError() {
        return this.schemaValidationAction(ValidationAction.ERROR);
    }

    public CollectionOptions schemaValidationLevel(ValidationLevel validationLevel) {
        Assert.notNull((Object)validationLevel, (String)"ValidationLevel must not be null!");
        return this.validation(this.validationOptions.validationLevel(validationLevel));
    }

    public CollectionOptions schemaValidationAction(ValidationAction validationAction) {
        Assert.notNull((Object)validationAction, (String)"ValidationAction must not be null!");
        return this.validation(this.validationOptions.validationAction(validationAction));
    }

    public CollectionOptions validation(ValidationOptions validationOptions) {
        Assert.notNull((Object)validationOptions, (String)"ValidationOptions must not be null!");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, validationOptions);
    }

    public Optional<Long> getMaxDocuments() {
        return Optional.ofNullable(this.maxDocuments);
    }

    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> getCapped() {
        return Optional.ofNullable(this.capped);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<ValidationOptions> getValidationOptions() {
        return this.validationOptions.isEmpty() ? Optional.empty() : Optional.of(this.validationOptions);
    }

    public static class ValidationOptions {
        private static final ValidationOptions NONE = new ValidationOptions(null, null, null);
        @Nullable
        private final Validator validator;
        @Nullable
        private final ValidationLevel validationLevel;
        @Nullable
        private final ValidationAction validationAction;

        public static ValidationOptions none() {
            return NONE;
        }

        public ValidationOptions validator(@Nullable Validator validator) {
            return new ValidationOptions(validator, this.validationLevel, this.validationAction);
        }

        public ValidationOptions validationLevel(ValidationLevel validationLevel) {
            return new ValidationOptions(this.validator, validationLevel, this.validationAction);
        }

        public ValidationOptions validationAction(ValidationAction validationAction) {
            return new ValidationOptions(this.validator, this.validationLevel, validationAction);
        }

        public Optional<Validator> getValidator() {
            return Optional.ofNullable(this.validator);
        }

        public Optional<ValidationLevel> getValidationLevel() {
            return Optional.ofNullable(this.validationLevel);
        }

        public Optional<ValidationAction> getValidationAction() {
            return Optional.ofNullable(this.validationAction);
        }

        boolean isEmpty() {
            return !Optionals.isAnyPresent((Optional[])new Optional[]{this.getValidator(), this.getValidationAction(), this.getValidationLevel()});
        }

        public ValidationOptions(@Nullable Validator validator, @Nullable ValidationLevel validationLevel, @Nullable ValidationAction validationAction) {
            this.validator = validator;
            this.validationLevel = validationLevel;
            this.validationAction = validationAction;
        }
    }
}

