/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import com.mongodb.client.MongoCursor;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.messaging.LazyMappingDelegatingMessage;
import org.springframework.data.mongodb.core.messaging.Message;
import org.springframework.data.mongodb.core.messaging.SimpleMessage;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.messaging.Task;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

abstract class CursorReadingTask<T, R>
implements Task {
    private final Object lifecycleMonitor = new Object();
    private final MongoTemplate template;
    private final SubscriptionRequest<T, R, SubscriptionRequest.RequestOptions> request;
    private final Class<R> targetType;
    private final ErrorHandler errorHandler;
    private final CountDownLatch awaitStart = new CountDownLatch(1);
    private Task.State state = Task.State.CREATED;
    private MongoCursor<T> cursor;

    CursorReadingTask(MongoTemplate template, SubscriptionRequest<?, ? super T, ? extends SubscriptionRequest.RequestOptions> request, Class<R> targetType, ErrorHandler errorHandler) {
        this.template = template;
        this.request = request;
        this.targetType = targetType;
        this.errorHandler = errorHandler;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[WHILELOOP], 1[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!Task.State.RUNNING.equals((Object)this.state)) {
                this.state = Task.State.STARTING;
            }
        }
        do {
            boolean valid = false;
            Object object2 = this.lifecycleMonitor;
            synchronized (object2) {
                if (Task.State.STARTING.equals((Object)this.state)) {
                    MongoCursor cursor = this.execute(() -> this.initCursor(this.template, this.request.getRequestOptions(), this.targetType));
                    valid = CursorReadingTask.isValidCursor(cursor);
                    if (valid) {
                        this.cursor = cursor;
                        this.state = Task.State.RUNNING;
                    } else if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            if (valid) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Object object3 = this.lifecycleMonitor;
                synchronized (object3) {
                    this.state = Task.State.CANCELLED;
                }
                Thread.currentThread().interrupt();
            }
        } while (Task.State.STARTING.equals((Object)this.getState()));
        if (this.awaitStart.getCount() == 1L) {
            this.awaitStart.countDown();
        }
    }

    protected abstract MongoCursor<T> initCursor(MongoTemplate var1, SubscriptionRequest.RequestOptions var2, Class<?> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws DataAccessResourceFailureException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (Task.State.RUNNING.equals((Object)this.state) || Task.State.STARTING.equals((Object)this.state)) {
                this.state = Task.State.CANCELLED;
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
        }
    }

    public boolean isLongLived() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task.State getState() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public boolean awaitStart(Duration timeout) throws InterruptedException {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative!");
        return this.awaitStart.await(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    protected Message<T, R> createMessage(T source, Class<R> targetType, SubscriptionRequest.RequestOptions options) {
        SimpleMessage<T, T> message = new SimpleMessage<T, T>(source, source, Message.MessageProperties.builder().databaseName(this.template.getDb().getName()).collectionName(options.getCollectionName()).build());
        return new LazyMappingDelegatingMessage<T, R>(message, targetType, this.template.getConverter());
    }

    private boolean isRunning() {
        return Task.State.RUNNING.equals((Object)this.getState());
    }

    private void emitMessage(Message<T, R> message) {
        try {
            this.request.getMessageListener().onMessage(message);
        }
        catch (Exception e) {
            this.errorHandler.handleError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T getNext() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (Task.State.RUNNING.equals((Object)this.state)) {
                return (T)this.cursor.tryNext();
            }
        }
        throw new IllegalStateException(String.format("Cursor %s is not longer open.", this.cursor));
    }

    private static boolean isValidCursor(@Nullable MongoCursor<?> cursor) {
        if (cursor == null) {
            return false;
        }
        return cursor.getServerCursor() != null && cursor.getServerCursor().getId() != 0L;
    }

    @Nullable
    private <V> V execute(Supplier<V> callback) {
        try {
            return callback.get();
        }
        catch (RuntimeException e) {
            DataAccessException translated = this.template.getExceptionTranslator().translateExceptionIfPossible(e);
            Object toHandle = translated != null ? translated : e;
            this.errorHandler.handleError((Throwable)toHandle);
            throw toHandle;
        }
    }
}

