/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.core.task;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.registry.Registration;
import reactor.event.registry.Registry;
import reactor.event.routing.EventRouter;
import reactor.event.selector.Selector;
import reactor.function.Consumer;

public class DispatcherTaskExecutor
implements TaskExecutor {
    private final Registry<Consumer<? extends Event<?>>> consumerRegistry = new EmptyConsumerRegistry();
    private final EventRouter eventRouter = new RunnableEventRouter();
    private final Dispatcher dispatcher;

    @Autowired
    public DispatcherTaskExecutor(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void execute(Runnable task) {
        this.dispatcher.dispatch(null, Event.wrap((Object)task), this.consumerRegistry, null, this.eventRouter, null);
    }

    private static final class EmptyConsumerRegistry
    implements Registry<Consumer<? extends Event<?>>> {
        private EmptyConsumerRegistry() {
        }

        public Iterator<Registration<? extends Consumer<? extends Event<?>>>> iterator() {
            throw new UnsupportedOperationException();
        }

        public <V extends Consumer<? extends Event<?>>> Registration<V> register(Selector sel, V obj) {
            throw new UnsupportedOperationException();
        }

        public boolean unregister(Object key) {
            throw new UnsupportedOperationException();
        }

        public List<Registration<? extends Consumer<? extends Event<?>>>> select(Object key) {
            return Collections.emptyList();
        }
    }

    private static final class RunnableEventRouter
    implements EventRouter {
        private RunnableEventRouter() {
        }

        public void route(Object key, Event<?> event, List<Registration<? extends Consumer<? extends Event<?>>>> consumers, Consumer<?> completionConsumer, Consumer<Throwable> errorConsumer) {
            ((Runnable)event.getData()).run();
        }
    }
}

