/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.SingleServerBinding;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.selector.ServerSelector;
import org.bson.assertions.Assertions;

public class ClientSessionBinding
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.ownsSession = ownsSession;
        this.sessionContext = new SyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    public ConnectionSource getReadConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapConnectionSource(this.wrapped.getReadConnectionSource()));
    }

    public ConnectionSource getWriteConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapConnectionSource(this.wrapped.getWriteConnectionSource()));
    }

    private ConnectionSource wrapConnectionSource(ConnectionSource connectionSource) {
        ConnectionSource retVal = connectionSource;
        if (this.isActiveShardedTxn()) {
            this.setPinnedServerAddress();
            SingleServerBinding binding = new SingleServerBinding(this.wrapped.getCluster(), this.session.getPinnedServerAddress(), this.wrapped.getReadPreference());
            retVal = binding.getWriteConnectionSource();
            binding.release();
        }
        return retVal;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private boolean isActiveShardedTxn() {
        return this.session.hasActiveTransaction() && this.wrapped.getCluster().getDescription().getType() == ClusterType.SHARDED;
    }

    private void setPinnedServerAddress() {
        if (this.session.getPinnedServerAddress() == null) {
            Server server = this.wrapped.getCluster().selectServer((ServerSelector)new ReadPreferenceServerSelector(this.wrapped.getReadPreference()));
            this.session.setPinnedServerAddress(server.getDescription().getAddress());
        }
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public Connection getConnection() {
            return this.wrapped.getConnection();
        }

        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

