/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.Date;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.task.api.history.HistoricTaskLogEntry;
import org.flowable.task.api.history.HistoricTaskLogEntryQuery;
import org.flowable.task.service.impl.AbstractQuery;
import org.flowable.task.service.impl.HistoricTaskLogEntryQueryProperty;
import org.flowable.task.service.impl.util.CommandContextUtil;

public class HistoricTaskLogEntryQueryImpl
extends AbstractQuery<HistoricTaskLogEntryQuery, HistoricTaskLogEntry>
implements HistoricTaskLogEntryQuery {
    protected String taskId;
    protected String type;
    protected String userId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String scopeId;
    protected String scopeDefinitionId;
    protected String subScopeId;
    protected String scopeType;
    protected Date fromDate;
    protected Date toDate;
    protected String tenantId;
    protected long fromLogNumber = -1L;
    protected long toLogNumber = -1L;

    public HistoricTaskLogEntryQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public HistoricTaskLogEntryQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public HistoricTaskLogEntryQuery type(String type) {
        this.type = type;
        return this;
    }

    public HistoricTaskLogEntryQuery userId(String userId) {
        this.userId = userId;
        return this;
    }

    public HistoricTaskLogEntryQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoricTaskLogEntryQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public HistoricTaskLogEntryQuery scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    public HistoricTaskLogEntryQuery scopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
        return this;
    }

    public HistoricTaskLogEntryQuery subScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
        return this;
    }

    public HistoricTaskLogEntryQuery scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public HistoricTaskLogEntryQuery from(Date fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public HistoricTaskLogEntryQuery to(Date toDate) {
        this.toDate = toDate;
        return this;
    }

    public HistoricTaskLogEntryQuery tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public HistoricTaskLogEntryQuery fromLogNumber(long fromLogNumber) {
        this.fromLogNumber = fromLogNumber;
        return this;
    }

    public HistoricTaskLogEntryQuery toLogNumber(long toLogNumber) {
        this.toLogNumber = toLogNumber;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public long getFromLogNumber() {
        return this.fromLogNumber;
    }

    public long getToLogNumber() {
        return this.toLogNumber;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getHistoricTaskLogEntryEntityManager(commandContext).findHistoricTaskLogEntriesCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricTaskLogEntry> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getHistoricTaskLogEntryEntityManager(commandContext).findHistoricTaskLogEntriesByQueryCriteria(this);
    }

    public HistoricTaskLogEntryQuery orderByLogNumber() {
        this.orderBy(HistoricTaskLogEntryQueryProperty.LOG_NUMBER);
        return this;
    }

    public HistoricTaskLogEntryQuery orderByTimeStamp() {
        this.orderBy(HistoricTaskLogEntryQueryProperty.TIME_STAMP);
        return this;
    }
}

