/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;

class ResolverDebugUtils {
    ResolverDebugUtils() {
    }

    public static String toDebugString(IQueryable<IInstallableUnit> ius, boolean verbose, IProgressMonitor monitor) {
        IQueryResult collector = ius.query(QueryUtil.ALL_UNITS, monitor);
        return ResolverDebugUtils.toDebugString(collector.toUnmodifiableSet(), verbose);
    }

    public static String toDebugString(Collection<IInstallableUnit> ius, boolean verbose) {
        if (ius == null || ius.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        if (verbose) {
            try {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    new MetadataIO().writeXML(new LinkedHashSet<IInstallableUnit>(ius), (OutputStream)os);
                }
                sb.append(os.toString("UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (IInstallableUnit iu : ius) {
            sb.append("  ").append(iu.toString()).append("\n");
        }
        return sb.toString();
    }
}

