/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.remote.RemoteAgentManager;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.resolver.P2ResolverImpl;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.PomDependencyCollectorImpl;
import org.eclipse.tycho.p2.target.TargetDefinitionResolverService;
import org.eclipse.tycho.p2.target.TargetPlatformFactoryImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;

public class P2ResolverFactoryImpl
implements P2ResolverFactory {
    private static LocalMetadataRepository localMetadataRepository;
    private static LocalArtifactRepository localArtifactRepository;
    private MavenContext mavenContext;
    private LocalRepositoryP2Indices localRepoIndices;
    private RemoteAgentManager remoteAgentManager;
    private TargetDefinitionResolverService targetDefinitionResolverService;

    private static synchronized LocalMetadataRepository getLocalMetadataRepository(MavenContext context, LocalRepositoryP2Indices localRepoIndices) {
        if (localMetadataRepository == null) {
            File localMavenRepoRoot = context.getLocalRepositoryRoot();
            LocalRepositoryReader contentLocator = new LocalRepositoryReader(localMavenRepoRoot);
            localMetadataRepository = new LocalMetadataRepository(localMavenRepoRoot.toURI(), localRepoIndices.getMetadataIndex(), (RepositoryReader)contentLocator);
        }
        return localMetadataRepository;
    }

    private static synchronized LocalArtifactRepository getLocalArtifactRepository(MavenContext mavenContext, LocalRepositoryP2Indices localRepoIndices) {
        if (localArtifactRepository == null) {
            LocalRepositoryReader contentLocator = new LocalRepositoryReader(mavenContext.getLocalRepositoryRoot());
            localArtifactRepository = new LocalArtifactRepository(localRepoIndices, (RepositoryReader)contentLocator);
        }
        return localArtifactRepository;
    }

    public PomDependencyCollector newPomDependencyCollector() {
        return new PomDependencyCollectorImpl(this.mavenContext);
    }

    public TargetPlatformFactoryImpl getTargetPlatformFactory() {
        try {
            LocalMetadataRepository localMetadataRepo = P2ResolverFactoryImpl.getLocalMetadataRepository(this.mavenContext, this.localRepoIndices);
            LocalArtifactRepository localArtifactRepo = P2ResolverFactoryImpl.getLocalArtifactRepository(this.mavenContext, this.localRepoIndices);
            return new TargetPlatformFactoryImpl(this.mavenContext, this.remoteAgentManager.getProvisioningAgent(), localArtifactRepo, localMetadataRepo, this.targetDefinitionResolverService);
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
    }

    public P2ResolverImpl createResolver(MavenLogger logger) {
        return new P2ResolverImpl(this.getTargetPlatformFactory(), logger);
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setLocalRepositoryIndices(LocalRepositoryP2Indices localRepoIndices) {
        this.localRepoIndices = localRepoIndices;
    }

    public void setRemoteAgentManager(RemoteAgentManager remoteAgentManager) {
        this.remoteAgentManager = remoteAgentManager;
    }

    public void setTargetDefinitionResolverService(TargetDefinitionResolverService targetDefinitionResolverService) {
        this.targetDefinitionResolverService = targetDefinitionResolverService;
    }
}

