/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.maven.polyglot.PolyglotModelManager;
import org.sonatype.maven.polyglot.PolyglotModelUtil;
import org.sonatype.maven.polyglot.io.ModelReaderSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Component(role=ModelReader.class, hint="tycho")
public class TychoModelReader
extends ModelReaderSupport {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String QUALIFIER_SUFFIX = ".qualifier";
    @Requirement
    private PolyglotModelManager polyglotModelManager;

    public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
        File projectRoot = new File(PolyglotModelUtil.getLocation(options)).getParentFile();
        File manifestFile = new File(projectRoot, "META-INF/MANIFEST.MF");
        File featureXml = new File(projectRoot, "feature.xml");
        File productXml = this.getProductFile(projectRoot);
        if (manifestFile.isFile()) {
            return this.createPomFromManifest(manifestFile);
        }
        if (featureXml.isFile()) {
            return this.createPomFromFeatureXml(featureXml);
        }
        if (productXml != null) {
            return this.createPomFromProductXml(productXml);
        }
        throw new IOException("Neither META-INF/MANIFEST.MF nor feature.xml nor .product file found in " + projectRoot);
    }

    private Model createPomFromManifest(File manifestFile) throws IOException, ModelParseException {
        Attributes headers = this.readManifestHeaders(manifestFile);
        String bundleSymbolicName = this.getBundleSymbolicName(headers, manifestFile);
        Model model = this.createModel();
        model.setParent(this.findParent(manifestFile.getParentFile().getParentFile()));
        model.setArtifactId(bundleSymbolicName);
        String bundleVersion = this.getRequiredHeaderValue("Bundle-Version", headers, manifestFile);
        model.setVersion(TychoModelReader.getPomVersion(bundleVersion));
        model.setPackaging(this.getPackagingType(bundleSymbolicName));
        return model;
    }

    private Model createPomFromFeatureXml(File featureXml) throws IOException, ModelParseException {
        Model model = this.createPomFromXmlFile(featureXml, "id", "version");
        model.setPackaging("eclipse-feature");
        return model;
    }

    private Model createPomFromProductXml(File productXml) throws IOException, ModelParseException {
        Model model = this.createPomFromXmlFile(productXml, "uid", "version");
        model.setPackaging("eclipse-repository");
        Build build = new Build();
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setArtifactId("tycho-p2-director-plugin");
        plugin.setGroupId("org.eclipse.tycho");
        PluginExecution materialize = new PluginExecution();
        materialize.setId("materialize-prodcuts");
        materialize.setGoals(Arrays.asList("materialize-products"));
        plugin.addExecution(materialize);
        PluginExecution archive = new PluginExecution();
        archive.setId("archive-prodcuts");
        archive.setGoals(Arrays.asList("archive-products"));
        plugin.addExecution(archive);
        model.setBuild(build);
        return model;
    }

    private Model createPomFromXmlFile(File xmlFile, String idAttributeName, String versionAttributeName) throws IOException, ModelParseException {
        Document doc;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(xmlFile);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new ModelParseException(e.getMessage(), -1, -1);
        }
        Element root = doc.getDocumentElement();
        Model model = this.createModel();
        model.setParent(this.findParent(xmlFile.getParentFile()));
        Attr idNode = root.getAttributeNode(idAttributeName);
        if (idNode == null) {
            throw new ModelParseException(String.format("missing %s attribute in root element (%s)", idAttributeName, xmlFile.getAbsolutePath()), -1, -1);
        }
        model.setArtifactId(idNode.getValue());
        Attr versionNode = root.getAttributeNode(versionAttributeName);
        if (versionNode == null) {
            throw new ModelParseException(String.format("missing %s attribute in root element (%s)", versionAttributeName, xmlFile.getAbsolutePath()), -1, -1);
        }
        model.setVersion(TychoModelReader.getPomVersion(versionNode.getValue()));
        return model;
    }

    private Model createModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        return model;
    }

    private String getBundleSymbolicName(Attributes headers, File manifestFile) throws ModelParseException {
        String symbolicName = this.getRequiredHeaderValue(BUNDLE_SYMBOLIC_NAME, headers, manifestFile);
        int semicolonIndex = symbolicName.indexOf(59);
        if (semicolonIndex > 0) {
            symbolicName = symbolicName.substring(0, semicolonIndex);
        }
        return symbolicName;
    }

    private String getRequiredHeaderValue(String headerKey, Attributes headers, File manifestFile) throws ModelParseException {
        String value = headers.getValue(headerKey);
        if (value == null) {
            throw new ModelParseException("Required header " + headerKey + " missing in " + manifestFile, -1, -1);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes readManifestHeaders(File manifestFile) throws IOException {
        Manifest manifest = new Manifest();
        try (FileInputStream stream = new FileInputStream(manifestFile);){
            manifest.read(stream);
        }
        return manifest.getMainAttributes();
    }

    private static String getPomVersion(String pdeVersion) {
        String pomVersion = pdeVersion;
        if (pdeVersion.endsWith(QUALIFIER_SUFFIX)) {
            pomVersion = pdeVersion.substring(0, pdeVersion.length() - QUALIFIER_SUFFIX.length()) + "-SNAPSHOT";
        }
        return pomVersion;
    }

    private String getPackagingType(String symbolicName) {
        if (symbolicName.endsWith(".tests")) {
            return "eclipse-test-plugin";
        }
        return "eclipse-plugin";
    }

    private File getProductFile(File projectRoot) {
        File[] productFiles = projectRoot.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".product");
            }
        });
        if (productFiles.length > 0 && productFiles[0].isFile()) {
            return productFiles[0];
        }
        return null;
    }

    Parent findParent(File projectRoot) throws ModelParseException, IOException {
        File parentPom = this.polyglotModelManager.locatePom(projectRoot.getParentFile());
        if (parentPom == null) {
            throw new FileNotFoundException("No parent pom file found in " + projectRoot.getParentFile());
        }
        HashMap<String, File> options = new HashMap<String, File>(4);
        options.put("org.apache.maven.model.building.source", parentPom);
        ModelReader reader = this.polyglotModelManager.getReaderFor(options);
        Model parentModel = reader.read(parentPom, options);
        Parent parentReference = new Parent();
        String groupId = parentModel.getGroupId();
        if (groupId == null) {
            groupId = parentModel.getParent().getGroupId();
        }
        parentReference.setGroupId(groupId);
        parentReference.setArtifactId(parentModel.getArtifactId());
        String version = parentModel.getVersion();
        if (version == null) {
            version = parentModel.getParent().getVersion();
        }
        parentReference.setVersion(version);
        return parentReference;
    }
}

