/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;

final class OlePropertyChangeSink {
    private OleControlSite controlSite;
    private COMObject iUnknown;
    private COMObject iPropertyNotifySink;
    private int refCount;
    private int propertyCookie;
    private OleEventTable eventTable;

    OlePropertyChangeSink(OleControlSite oleControlSite) {
        this.controlSite = oleControlSite;
        this.createCOMInterfaces();
    }

    void addListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void connect(IUnknown iUnknown) {
        int[] nArray = new int[1];
        if (iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                int[] nArray2 = new int[1];
                if (iConnectionPoint.Advise(this.iPropertyNotifySink.getAddress(), nArray2) == 0) {
                    this.propertyCookie = nArray2[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void createCOMInterfaces() {
        this.iUnknown = new COMObject(new int[]{2, 0, 0}){

            public int method0(int[] nArray) {
                return OlePropertyChangeSink.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OlePropertyChangeSink.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OlePropertyChangeSink.this.Release();
            }
        };
        this.iPropertyNotifySink = new COMObject(new int[]{2, 0, 0, 1, 1}){

            public int method0(int[] nArray) {
                return OlePropertyChangeSink.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OlePropertyChangeSink.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OlePropertyChangeSink.this.Release();
            }

            public int method3(int[] nArray) {
                return OlePropertyChangeSink.this.OnChanged(nArray[0]);
            }

            public int method4(int[] nArray) {
                return OlePropertyChangeSink.this.OnRequestEdit(nArray[0]);
            }
        };
    }

    void disconnect(IUnknown iUnknown) {
        int[] nArray;
        if (this.propertyCookie != 0 && iUnknown != null && iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray = new int[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                if (iConnectionPoint.Unadvise(this.propertyCookie) == 0) {
                    this.propertyCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iPropertyNotifySink != null) {
            this.iPropertyNotifySink.dispose();
        }
        this.iPropertyNotifySink = null;
    }

    private void notifyListener(int n, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n;
        oleEvent.widget = this.controlSite;
        this.eventTable.sendEvent(oleEvent);
    }

    private int OnChanged(int n) {
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.detail = 1;
        this.notifyListener(n, oleEvent);
        return 0;
    }

    private int OnRequestEdit(int n) {
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.doit = true;
        oleEvent.detail = 0;
        this.notifyListener(n, oleEvent);
        return oleEvent.doit ? 0 : 1;
    }

    private int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iUnknown.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIPropertyNotifySink)) {
            COM.MoveMemory(n2, new int[]{this.iPropertyNotifySink.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, oleListener);
    }
}

