/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOuterShadowEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;

public class XSLFShadow
extends XSLFSimpleShape {
    private XSLFSimpleShape _parent;

    XSLFShadow(CTOuterShadowEffect shape, XSLFSimpleShape parentShape) {
        super((XmlObject)shape, parentShape.getSheet());
        this._parent = parentShape;
    }

    public void fill(Graphics2D graphics, Shape outline) {
        double shapeRotation = this._parent.getRotation();
        if (this._parent.getFlipVertical()) {
            shapeRotation += 180.0;
        }
        double angle = this.getAngle() - shapeRotation;
        double dist = this.getDistance();
        double dx = dist * Math.cos(Math.toRadians(angle));
        double dy = dist * Math.sin(Math.toRadians(angle));
        graphics.translate(dx, dy);
        Color fillColor = this.getFillColor();
        if (fillColor != null) {
            graphics.setColor(fillColor);
            graphics.fill(outline);
        }
        graphics.translate(-dx, -dy);
    }

    public void draw(Graphics2D graphics, Shape outline) {
        double angle = this.getAngle();
        double dist = this.getDistance();
        double dx = dist * Math.cos(Math.toRadians(angle));
        double dy = dist * Math.sin(Math.toRadians(angle));
        graphics.translate(dx, dy);
        Color fillColor = this.getFillColor();
        if (fillColor != null) {
            graphics.setColor(fillColor);
            graphics.draw(outline);
        }
        graphics.translate(-dx, -dy);
    }

    @Override
    public Rectangle2D getAnchor() {
        return this._parent.getAnchor();
    }

    @Override
    public void setAnchor(Rectangle2D anchor) {
        throw new IllegalStateException("You can't set anchor of a shadow");
    }

    public double getDistance() {
        CTOuterShadowEffect ct = (CTOuterShadowEffect)this.getXmlObject();
        return ct.isSetDist() ? Units.toPoints(ct.getDist()) : 0.0;
    }

    public double getAngle() {
        CTOuterShadowEffect ct = (CTOuterShadowEffect)this.getXmlObject();
        return ct.isSetDir() ? (double)ct.getDir() / 60000.0 : 0.0;
    }

    public double getBlur() {
        CTOuterShadowEffect ct = (CTOuterShadowEffect)this.getXmlObject();
        return ct.isSetBlurRad() ? Units.toPoints(ct.getBlurRad()) : 0.0;
    }

    @Override
    public Color getFillColor() {
        XSLFTheme theme = this.getSheet().getTheme();
        CTOuterShadowEffect ct = (CTOuterShadowEffect)this.getXmlObject();
        if (ct == null) {
            return null;
        }
        CTSchemeColor phClr = ct.getSchemeClr();
        return new XSLFColor((XmlObject)ct, theme, phClr).getColor();
    }
}

