/*
 * $Id$
 */

package org.apache.maven.shared.model.fileset;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class SetBase.
 * 
 * @version $Revision$ $Date$
 */
public class SetBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Specifies whether symbolic links should be
     * traversed, or handled as-is.
     *           
     */
    private boolean followSymlinks = false;

    /**
     * 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    private String outputDirectory;

    /**
     * 
     *             Whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     *           
     */
    private boolean useDefaultExcludes = false;

    /**
     * Field includes.
     */
    private java.util.List includes;

    /**
     * Field excludes.
     */
    private java.util.List excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     */
    private String fileMode = "0644";

    /**
     * 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     */
    private String directoryMode = "0755";

    /**
     * 
     *             Specifies the mapper used.
     *           
     */
    private Mapper mapper = new Mapper();


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "SetBase.addExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "SetBase.addIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().add( string );
    } //-- void addInclude(String) 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode() 

    /**
     * Method getExcludes.
     * 
     * @return java.util.List
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode() 

    /**
     * Method getIncludes.
     * 
     * @return java.util.List
     */
    public java.util.List getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList();
        }
        
        return this.includes;
    } //-- java.util.List getIncludes() 

    /**
     * Get 
     *             Specifies the mapper used.
     *           
     * 
     * @return Mapper
     */
    public Mapper getMapper()
    {
        return this.mapper;
    } //-- Mapper getMapper() 

    /**
     * Get 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Get 
     *             Specifies whether symbolic links should be
     * traversed, or handled as-is.
     *           
     * 
     * @return boolean
     */
    public boolean isFollowSymlinks()
    {
        return this.followSymlinks;
    } //-- boolean isFollowSymlinks() 

    /**
     * Get 
     *             Whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     *           
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes() 

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "SetBase.removeExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "SetBase.removeIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().remove( string );
    } //-- void removeInclude(String) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     * 
     * @param directoryMode
     */
    public void setDirectoryMode(String directoryMode)
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode(String) 

    /**
     * Set 
     *             
     *             When &lt;exclude&gt; subelements are present,
     * they define
     *             a set of files and directory to exclude.
     *             
     *           
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     * 
     * @param fileMode
     */
    public void setFileMode(String fileMode)
    {
        this.fileMode = fileMode;
    } //-- void setFileMode(String) 

    /**
     * Set 
     *             Specifies whether symbolic links should be
     * traversed, or handled as-is.
     *           
     * 
     * @param followSymlinks
     */
    public void setFollowSymlinks(boolean followSymlinks)
    {
        this.followSymlinks = followSymlinks;
    } //-- void setFollowSymlinks(boolean) 

    /**
     * Set 
     *             
     *             When &lt;include&gt; subelements are present,
     * they define
     *             a set of files and directory to include.
     *             
     *           
     * 
     * @param includes
     */
    public void setIncludes(java.util.List includes)
    {
        this.includes = includes;
    } //-- void setIncludes(java.util.List) 

    /**
     * Set 
     *             Specifies the mapper used.
     *           
     * 
     * @param mapper
     */
    public void setMapper(Mapper mapper)
    {
        this.mapper = mapper;
    } //-- void setMapper(Mapper) 

    /**
     * Set 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Set 
     *             Whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     *           
     * 
     * @param useDefaultExcludes
     */
    public void setUseDefaultExcludes(boolean useDefaultExcludes)
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes(boolean) 


    /**
     * @return the file-set inclusion rules in array form.
     */
    public String[] getIncludesArray()
    {
        String[] includesArry = null;
        java.util.Collection includes = getIncludes();
        if ( includes != null && !includes.isEmpty() )
        {
            includesArry = (String[]) includes.toArray( new String[0] );
        }
        else if ( includes != null )
        {
            includesArry = new String[0];
        }

        return includesArry;
    }

    /**
     * @return the file-set exclusion rules in array form.
     */
    public String[] getExcludesArray()
    {
        String[] excludesArry = null;
        java.util.Collection excludes = getExcludes();
        if ( excludes != null && !excludes.isEmpty() )
        {
            excludesArry = (String[]) excludes.toArray( new String[0] );
        }
        else if ( excludes != null )
        {
            excludesArry = new String[0];
        }

        return excludesArry;
    }

          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
