/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractSiteMojo
extends AbstractMojo {
    @Parameter(property="locales", defaultValue="en")
    private String locales;
    @Parameter(property="maven.site.skip", defaultValue="false")
    protected boolean skip;
    @Component
    protected SiteTool siteTool;
    @Component
    protected I18N i18n;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;

    protected static boolean isMaven3OrMore() {
        return new ComparableVersion(AbstractSiteMojo.getMavenVersion()).compareTo(new ComparableVersion("3.0")) >= 0;
    }

    protected static String getMavenVersion() {
        Properties properties = new Properties();
        String corePomProperties = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
        try (InputStream in = MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            properties.load(in);
        }
        catch (IOException ioe) {
            return "";
        }
        return properties.getProperty("version").trim();
    }

    protected List<Locale> getLocales() {
        return this.siteTool.getSiteLocales(this.locales);
    }
}

