/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsXmlArchiverFileFilter
implements ContainerDescriptorHandler {
    protected Map<String, Xpp3Dom> components;
    private boolean excludeOverride = false;
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    protected void addComponentsXml(Reader componentsReader) throws XmlPullParserException, IOException {
        Xpp3Dom newDom = Xpp3DomBuilder.build((Reader)componentsReader);
        if (newDom != null) {
            newDom = newDom.getChild("components");
        }
        if (newDom != null) {
            Xpp3Dom[] children;
            for (Xpp3Dom component : children = newDom.getChildren()) {
                if (this.components == null) {
                    this.components = new LinkedHashMap<String, Xpp3Dom>();
                }
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                String key = role + roleHint;
                if (!this.components.containsKey(key)) {
                    System.out.println("Adding " + key);
                    this.components.put(key, component);
                    continue;
                }
                System.out.println("Component: " + key + " is already defined. Skipping.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToArchive(Archiver archiver) throws IOException, ArchiverException {
        if (this.components != null) {
            File f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            try {
                Xpp3Dom dom = new Xpp3Dom("component-set");
                Xpp3Dom componentDom = new Xpp3Dom("components");
                dom.addChild(componentDom);
                for (Xpp3Dom component : this.components.values()) {
                    componentDom.addChild(component);
                }
                Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)dom);
            }
            finally {
                IOUtil.close((Writer)fileWriter);
            }
            this.excludeOverride = true;
            archiver.addFile(f, COMPONENTS_XML_PATH);
            this.excludeOverride = false;
        }
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        ResourceIterator it = archiver.getResources();
        while (it.hasNext()) {
            it.next();
        }
        try {
            this.addToArchive(archiver);
        }
        catch (IOException e) {
            throw new ArchiverException("Error finalizing component-set for archive. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getVirtualFiles() {
        if (this.components != null && !this.components.isEmpty()) {
            return Collections.singletonList(COMPONENTS_XML_PATH);
        }
        return null;
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        block6: {
            block7: {
                if (!fileInfo.isFile()) break block6;
                if (this.excludeOverride) {
                    return true;
                }
                String entry = fileInfo.getName().replace('\\', '/');
                if (entry.startsWith("/")) {
                    entry = entry.substring(1);
                }
                if (!COMPONENTS_XML_PATH.equals(entry)) break block7;
                InputStream stream = null;
                InputStreamReader reader = null;
                try {
                    stream = fileInfo.getContents();
                    reader = new InputStreamReader(stream, "UTF-8");
                    this.addComponentsXml(new BufferedReader(reader, 8192));
                }
                catch (XmlPullParserException e) {
                    try {
                        IOException error = new IOException("Error finalizing component-set for archive. Reason: " + e.getMessage());
                        error.initCause(e);
                        throw error;
                    }
                    catch (Throwable throwable) {
                        IOUtil.close((InputStream)stream);
                        IOUtil.close(reader);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)stream);
                IOUtil.close((Reader)reader);
                return false;
            }
            return true;
        }
        return true;
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
    }
}

