/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKeyValueStore
implements KeyValueStore<Bytes, byte[]> {
    private final String name;
    private final ConcurrentNavigableMap<Bytes, byte[]> map = new ConcurrentSkipListMap<Bytes, byte[]>();
    private volatile boolean open = false;
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryKeyValueStore.class);

    public InMemoryKeyValueStore(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        if (root != null) {
            context.register(root, (key, value) -> {
                if (value == null) {
                    this.delete(Bytes.wrap((byte[])key));
                } else {
                    this.put(Bytes.wrap((byte[])key), value);
                }
            });
        }
        this.open = true;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public byte[] get(Bytes key) {
        return (byte[])this.map.get(key);
    }

    @Override
    public void put(Bytes key, byte[] value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            this.put((Bytes)entry.key, (byte[])entry.value);
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        return (byte[])this.map.remove(key);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.subMap((Object)from, true, (Object)to, true).entrySet().iterator()));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.entrySet().iterator()));
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.map.clear();
        this.open = false;
    }

    private static class InMemoryKeyValueIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final Iterator<Map.Entry<Bytes, byte[]>> iter;

        private InMemoryKeyValueIterator(Iterator<Map.Entry<Bytes, byte[]>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            Map.Entry<Bytes, byte[]> entry = this.iter.next();
            return new KeyValue<Bytes, byte[]>(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

