/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AssignedStandbyTasks;
import org.apache.kafka.streams.processor.internals.AssignedStreamsTasks;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;

public class TaskManager {
    private final Logger log;
    private final UUID processId;
    private final AssignedStreamsTasks active;
    private final AssignedStandbyTasks standby;
    private final ChangelogReader changelogReader;
    private final String logPrefix;
    private final Consumer<byte[], byte[]> restoreConsumer;
    private final StreamThread.AbstractTaskCreator<StreamTask> taskCreator;
    private final StreamThread.AbstractTaskCreator<StandbyTask> standbyTaskCreator;
    private final StreamsMetadataState streamsMetadataState;
    final AdminClient adminClient;
    private DeleteRecordsResult deleteRecordsResult;
    private Cluster cluster;
    private Map<TaskId, Set<TopicPartition>> assignedActiveTasks;
    private Map<TaskId, Set<TopicPartition>> assignedStandbyTasks;
    private Consumer<byte[], byte[]> consumer;

    TaskManager(ChangelogReader changelogReader, UUID processId, String logPrefix, Consumer<byte[], byte[]> restoreConsumer, StreamsMetadataState streamsMetadataState, StreamThread.AbstractTaskCreator<StreamTask> taskCreator, StreamThread.AbstractTaskCreator<StandbyTask> standbyTaskCreator, AdminClient adminClient, AssignedStreamsTasks active, AssignedStandbyTasks standby) {
        this.changelogReader = changelogReader;
        this.processId = processId;
        this.logPrefix = logPrefix;
        this.streamsMetadataState = streamsMetadataState;
        this.restoreConsumer = restoreConsumer;
        this.taskCreator = taskCreator;
        this.standbyTaskCreator = standbyTaskCreator;
        this.active = active;
        this.standby = standby;
        LogContext logContext = new LogContext(logPrefix);
        this.log = logContext.logger(this.getClass());
        this.adminClient = adminClient;
    }

    void createTasks(Collection<TopicPartition> assignment) {
        if (this.consumer == null) {
            throw new IllegalStateException(this.logPrefix + "consumer has not been initialized while adding stream tasks. This should not happen.");
        }
        this.standby.closeNonAssignedSuspendedTasks(this.assignedStandbyTasks);
        this.active.closeNonAssignedSuspendedTasks(this.assignedActiveTasks);
        this.addStreamTasks(assignment);
        this.addStandbyTasks();
        this.log.trace("Pausing partitions: {}", assignment);
        this.consumer.pause(assignment);
    }

    private void addStreamTasks(Collection<TopicPartition> assignment) {
        if (this.assignedActiveTasks.isEmpty()) {
            return;
        }
        HashMap<TaskId, Set<TopicPartition>> newTasks = new HashMap<TaskId, Set<TopicPartition>>();
        this.log.debug("Adding assigned tasks as active: {}", this.assignedActiveTasks);
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.assignedActiveTasks.entrySet()) {
            TaskId taskId = entry.getKey();
            Set<TopicPartition> partitions = entry.getValue();
            if (assignment.containsAll(partitions)) {
                try {
                    if (this.active.maybeResumeSuspendedTask(taskId, partitions)) continue;
                    newTasks.put(taskId, partitions);
                    continue;
                }
                catch (StreamsException e) {
                    this.log.error("Failed to resume an active task {} due to the following error:", (Object)taskId, (Object)e);
                    throw e;
                }
            }
            this.log.warn("Task {} owned partitions {} are not contained in the assignment {}", new Object[]{taskId, partitions, assignment});
        }
        if (newTasks.isEmpty()) {
            return;
        }
        this.log.trace("New active tasks to be created: {}", newTasks);
        for (StreamTask task : this.taskCreator.createTasks(this.consumer, newTasks)) {
            this.active.addNewTask(task);
        }
    }

    private void addStandbyTasks() {
        Map<TaskId, Set<TopicPartition>> assignedStandbyTasks = this.assignedStandbyTasks;
        if (assignedStandbyTasks.isEmpty()) {
            return;
        }
        this.log.debug("Adding assigned standby tasks {}", assignedStandbyTasks);
        HashMap<TaskId, Set<TopicPartition>> newStandbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : assignedStandbyTasks.entrySet()) {
            Set<TopicPartition> partitions;
            TaskId taskId = entry.getKey();
            if (this.standby.maybeResumeSuspendedTask(taskId, partitions = entry.getValue())) continue;
            newStandbyTasks.put(taskId, partitions);
        }
        if (newStandbyTasks.isEmpty()) {
            return;
        }
        this.log.trace("New standby tasks to be created: {}", newStandbyTasks);
        for (StandbyTask task : this.standbyTaskCreator.createTasks(this.consumer, newStandbyTasks)) {
            this.standby.addNewTask(task);
        }
    }

    Set<TaskId> activeTaskIds() {
        return this.active.allAssignedTaskIds();
    }

    Set<TaskId> standbyTaskIds() {
        return this.standby.allAssignedTaskIds();
    }

    public Set<TaskId> prevActiveTaskIds() {
        return this.active.previousTaskIds();
    }

    public Set<TaskId> cachedTasksIds() {
        HashSet<TaskId> tasks = new HashSet<TaskId>();
        File[] stateDirs = this.taskCreator.stateDirectory().listTaskDirectories();
        if (stateDirs != null) {
            for (File dir : stateDirs) {
                try {
                    TaskId id = TaskId.parse(dir.getName());
                    if (!new File(dir, ".checkpoint").exists()) continue;
                    tasks.add(id);
                }
                catch (TaskIdFormatException taskIdFormatException) {
                    // empty catch block
                }
            }
        }
        return tasks;
    }

    public UUID processId() {
        return this.processId;
    }

    InternalTopologyBuilder builder() {
        return this.taskCreator.builder();
    }

    void suspendTasksAndState() {
        this.log.debug("Suspending all active tasks {} and standby tasks {}", this.active.runningTaskIds(), this.standby.runningTaskIds());
        AtomicReference<Object> firstException = new AtomicReference<Object>(null);
        firstException.compareAndSet(null, this.active.suspend());
        firstException.compareAndSet(null, this.active.closeAllRestoringTasks());
        this.changelogReader.reset();
        firstException.compareAndSet(null, this.standby.suspend());
        this.restoreConsumer.unsubscribe();
        Exception exception = firstException.get();
        if (exception != null) {
            throw new StreamsException(this.logPrefix + "failed to suspend stream tasks", exception);
        }
    }

    void shutdown(boolean clean) {
        AtomicReference<Object> firstException = new AtomicReference<Object>(null);
        this.log.debug("Shutting down all active tasks {}, standby tasks {}, suspended tasks {}, and suspended standby tasks {}", new Object[]{this.active.runningTaskIds(), this.standby.runningTaskIds(), this.active.previousTaskIds(), this.standby.previousTaskIds()});
        try {
            this.active.close(clean);
        }
        catch (RuntimeException fatalException) {
            firstException.compareAndSet(null, fatalException);
        }
        this.standby.close(clean);
        try {
            this.restoreConsumer.unsubscribe();
        }
        catch (RuntimeException fatalException) {
            firstException.compareAndSet(null, fatalException);
        }
        this.taskCreator.close();
        this.standbyTaskCreator.close();
        RuntimeException fatalException = firstException.get();
        if (fatalException != null) {
            throw fatalException;
        }
    }

    AdminClient getAdminClient() {
        return this.adminClient;
    }

    Set<TaskId> suspendedActiveTaskIds() {
        return this.active.previousTaskIds();
    }

    Set<TaskId> suspendedStandbyTaskIds() {
        return this.standby.previousTaskIds();
    }

    StreamTask activeTask(TopicPartition partition) {
        return (StreamTask)this.active.runningTaskFor(partition);
    }

    StandbyTask standbyTask(TopicPartition partition) {
        return (StandbyTask)this.standby.runningTaskFor(partition);
    }

    Map<TaskId, StreamTask> activeTasks() {
        return this.active.runningTaskMap();
    }

    Map<TaskId, StandbyTask> standbyTasks() {
        return this.standby.runningTaskMap();
    }

    void setConsumer(Consumer<byte[], byte[]> consumer) {
        this.consumer = consumer;
    }

    boolean updateNewAndRestoringTasks() {
        this.active.initializeNewTasks();
        this.standby.initializeNewTasks();
        Collection<TopicPartition> restored = this.changelogReader.restore(this.active);
        this.active.updateRestored(restored);
        if (this.active.allTasksRunning()) {
            Set assignment = this.consumer.assignment();
            this.log.trace("Resuming partitions {}", (Object)assignment);
            this.consumer.resume((Collection)assignment);
            this.assignStandbyPartitions();
            return this.standby.allTasksRunning();
        }
        return false;
    }

    boolean hasActiveRunningTasks() {
        return this.active.hasRunningTasks();
    }

    boolean hasStandbyRunningTasks() {
        return this.standby.hasRunningTasks();
    }

    private void assignStandbyPartitions() {
        Collection running = this.standby.running();
        HashMap<TopicPartition, Long> checkpointedOffsets = new HashMap<TopicPartition, Long>();
        for (StandbyTask standbyTask : running) {
            checkpointedOffsets.putAll(standbyTask.checkpointedOffsets());
        }
        this.restoreConsumer.assign(checkpointedOffsets.keySet());
        for (Map.Entry entry : checkpointedOffsets.entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)entry.getValue();
            if (offset >= 0L) {
                this.restoreConsumer.seek(partition, offset);
                continue;
            }
            this.restoreConsumer.seekToBeginning(Collections.singleton(partition));
        }
    }

    public void setClusterMetadata(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setPartitionsByHostState(Map<HostInfo, Set<TopicPartition>> partitionsByHostState) {
        this.streamsMetadataState.onChange(partitionsByHostState, this.cluster);
    }

    public void setAssignmentMetadata(Map<TaskId, Set<TopicPartition>> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks) {
        this.assignedActiveTasks = activeTasks;
        this.assignedStandbyTasks = standbyTasks;
    }

    public void updateSubscriptionsFromAssignment(List<TopicPartition> partitions) {
        if (this.builder().sourceTopicPattern() != null) {
            HashSet<String> assignedTopics = new HashSet<String>();
            for (TopicPartition topicPartition : partitions) {
                assignedTopics.add(topicPartition.topic());
            }
            Collection<String> existingTopics = this.builder().subscriptionUpdates().getUpdates();
            if (!existingTopics.containsAll(assignedTopics)) {
                assignedTopics.addAll(existingTopics);
                this.builder().updateSubscribedTopics(assignedTopics, this.logPrefix);
            }
        }
    }

    public void updateSubscriptionsFromMetadata(Set<String> topics) {
        Collection<String> existingTopics;
        if (this.builder().sourceTopicPattern() != null && !(existingTopics = this.builder().subscriptionUpdates().getUpdates()).equals(topics)) {
            this.builder().updateSubscribedTopics(topics, this.logPrefix);
        }
    }

    int commitAll() {
        int committed = this.active.commit();
        return committed + this.standby.commit();
    }

    int process(long now) {
        return this.active.process(now);
    }

    int punctuate() {
        return this.active.punctuate();
    }

    int maybeCommitActiveTasksPerUserRequested() {
        return this.active.maybeCommitPerUserRequested();
    }

    void maybePurgeCommitedRecords() {
        if (this.deleteRecordsResult == null || this.deleteRecordsResult.all().isDone()) {
            if (this.deleteRecordsResult != null && this.deleteRecordsResult.all().isCompletedExceptionally()) {
                this.log.debug("Previous delete-records request has failed: {}. Try sending the new request now", (Object)this.deleteRecordsResult.lowWatermarks());
            }
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            for (Map.Entry<TopicPartition, Long> entry : this.active.recordsToDelete().entrySet()) {
                recordsToDelete.put(entry.getKey(), RecordsToDelete.beforeOffset((long)entry.getValue()));
            }
            this.deleteRecordsResult = this.adminClient.deleteRecords(recordsToDelete);
            this.log.trace("Sent delete-records request: {}", recordsToDelete);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskManager\n");
        builder.append(indent).append("\tMetadataState:\n");
        builder.append(this.streamsMetadataState.toString(indent + "\t\t"));
        builder.append(indent).append("\tActive tasks:\n");
        builder.append(this.active.toString(indent + "\t\t"));
        builder.append(indent).append("\tStandby tasks:\n");
        builder.append(this.standby.toString(indent + "\t\t"));
        return builder.toString();
    }

    Map<TaskId, Set<TopicPartition>> assignedActiveTasks() {
        return this.assignedActiveTasks;
    }

    Map<TaskId, Set<TopicPartition>> assignedStandbyTasks() {
        return this.assignedStandbyTasks;
    }
}

