/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeManagerHardwareUtils {
    public static float getContainersCores(Configuration conf) {
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        return NodeManagerHardwareUtils.getContainersCores(plugin, conf);
    }

    public static float getContainersCores(ResourceCalculatorPlugin plugin, Configuration conf) {
        int numProcessors = plugin.getNumProcessors();
        int nodeCpuPercentage = NodeManagerHardwareUtils.getNodeCpuPercentage(conf);
        return (float)(nodeCpuPercentage * numProcessors) / 100.0f;
    }

    public static int getNodeCpuPercentage(Configuration conf) {
        int nodeCpuPercentage = Math.min(conf.getInt("yarn.nodemanager.resource.percentage-physical-cpu-limit", 100), 100);
        if ((nodeCpuPercentage = Math.max(0, nodeCpuPercentage)) == 0) {
            String message = "Illegal value for yarn.nodemanager.resource.percentage-physical-cpu-limit. Value cannot be less than or equal to 0.";
            throw new IllegalArgumentException(message);
        }
        return nodeCpuPercentage;
    }
}

