/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.beans.factory.config;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.config.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class DubboConfigBeanDefinitionConflictProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BeanDefinitionRegistry registry;
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.resolveUniqueApplicationConfigBean(this.registry, beanFactory);
    }

    private void resolveUniqueApplicationConfigBean(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        this.environment = (Environment)beanFactory.getBean("environment", Environment.class);
        String[] beansNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ApplicationConfig.class);
        if (beansNames.length < 2) {
            return;
        }
        Stream.of(beansNames).filter(this::isConfiguredApplicationConfigBeanName).forEach(arg_0 -> ((BeanDefinitionRegistry)registry).removeBeanDefinition(arg_0));
        beansNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ApplicationConfig.class);
        if (beansNames.length > 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = ApplicationConfig.class.getSimpleName();
            objectArray[1] = Stream.of(beansNames).map(arg_0 -> ((BeanDefinitionRegistry)registry).getBeanDefinition(arg_0)).collect(Collectors.toList());
            throw new IllegalStateException(String.format("There are more than one instances of %s, whose bean definitions : %s", objectArray));
        }
    }

    private boolean isConfiguredApplicationConfigBeanName(String beanName) {
        boolean removed;
        boolean bl = removed = BeanFactoryUtils.isGeneratedBeanName((String)beanName) || Objects.equals(beanName, this.environment.getProperty("dubbo.application.id"));
        if (removed && this.logger.isWarnEnabled()) {
            this.logger.warn("The {} bean [ name : {} ] has been removed!", (Object)ApplicationConfig.class.getSimpleName(), (Object)beanName);
        }
        return removed;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

