/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.Collection;
import java.util.Vector;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBindingHandler
extends AbstractBindingBuilder {
    TransportBinding tbinding;

    public TransportBindingHandler(TransportBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(binding, saaj, secHeader, aim, message);
        this.tbinding = binding;
    }

    private void addUsernameTokens(SupportingToken sgndSuppTokens) {
        for (Token token : sgndSuppTokens.getTokens()) {
            if (token instanceof UsernameToken) {
                WSSecUsernameToken utBuilder = this.addUsernameToken((UsernameToken)token);
                if (utBuilder == null) continue;
                utBuilder.prepare((Document)this.saaj.getSOAPPart());
                utBuilder.appendToHeader(this.secHeader);
                continue;
            }
            if (!(token instanceof IssuedToken)) continue;
            SecurityToken secTok = this.getSecurityToken();
            SPConstants.IncludeTokenType inclusion = token.getInclusion();
            if (inclusion != SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS && (inclusion != SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT && inclusion != SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE || !this.isRequestor())) continue;
            this.addEncyptedKeyElement(this.cloneElement(secTok.getToken()));
        }
    }

    private static void addSig(Vector<byte[]> signatureValues, byte[] val) {
        if (val != null) {
            signatureValues.add(val);
        }
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        try {
            if (this.isRequestor()) {
                SupportingToken sgndSuppTokens;
                Vector<byte[]> signatureValues = new Vector<byte[]>();
                Collection ais = (Collection)this.aim.get((Object)SP12Constants.SIGNED_SUPPORTING_TOKENS);
                if (ais != null) {
                    sgndSuppTokens = null;
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (sgndSuppTokens != null) {
                        this.addUsernameTokens(sgndSuppTokens);
                    }
                }
                if ((ais = (Collection)this.aim.get((Object)SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS)) != null) {
                    sgndSuppTokens = null;
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (sgndSuppTokens != null) {
                        SignedEncryptedParts signdParts = sgndSuppTokens.getSignedParts();
                        for (Token token : sgndSuppTokens.getTokens()) {
                            if (token instanceof IssuedToken || token instanceof SecureConversationToken || token instanceof KeyValueToken) {
                                TransportBindingHandler.addSig(signatureValues, this.doIssuedTokenSignature(token, signdParts, sgndSuppTokens, null));
                                continue;
                            }
                            if (!(token instanceof X509Token) && !(token instanceof KeyValueToken)) continue;
                            TransportBindingHandler.addSig(signatureValues, this.doX509TokenSignature(token, signdParts, sgndSuppTokens));
                        }
                    }
                }
                if ((ais = (Collection)this.aim.get((Object)SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS)) != null) {
                    sgndSuppTokens = null;
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (sgndSuppTokens != null) {
                        this.addUsernameTokens(sgndSuppTokens);
                    }
                }
                if ((ais = (Collection)this.aim.get((Object)SP12Constants.ENDORSING_SUPPORTING_TOKENS)) != null) {
                    SupportingToken endSuppTokens = null;
                    for (AssertionInfo ai : ais) {
                        endSuppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (endSuppTokens != null) {
                        for (Token token : endSuppTokens.getTokens()) {
                            if (token instanceof IssuedToken || token instanceof SecureConversationToken) {
                                TransportBindingHandler.addSig(signatureValues, this.doIssuedTokenSignature(token, endSuppTokens.getSignedParts(), endSuppTokens, null));
                                continue;
                            }
                            if (!(token instanceof X509Token) && !(token instanceof KeyValueToken)) continue;
                            TransportBindingHandler.addSig(signatureValues, this.doX509TokenSignature(token, endSuppTokens.getSignedParts(), endSuppTokens));
                        }
                    }
                }
                if ((ais = (Collection)this.aim.get((Object)SP12Constants.SUPPORTING_TOKENS)) != null) {
                    SupportingToken suppTokens = null;
                    for (AssertionInfo ai : ais) {
                        suppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (suppTokens != null && suppTokens.getTokens() != null && suppTokens.getTokens().size() > 0) {
                        this.handleSupportingTokens(suppTokens, false);
                    }
                }
            } else {
                this.addSignatureConfirmation(null);
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private byte[] doX509TokenSignature(Token token, SignedEncryptedParts signdParts, TokenWrapper wrapper) throws Exception {
        SOAPPart doc = this.saaj.getSOAPPart();
        Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
        if (this.timestampEl != null) {
            sigParts.add(new WSEncryptionPart(this.timestampEl.getId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                sigParts.add(new WSEncryptionPart(this.addWsuIdToElement((Element)this.saaj.getSOAPBody())));
            }
            for (Header header : signdParts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        if (token.isDerivedKeys()) {
            WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(wrapper, token);
            Element bstElem = encrKey.getBinarySecurityTokenElement();
            if (bstElem != null) {
                this.addTopDownElement(bstElem);
            }
            encrKey.appendToHeader(this.secHeader);
            WSSecDKSign dkSig = new WSSecDKSign();
            dkSig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
            dkSig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
            dkSig.setDerivedKeyLength(this.binding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSig.setExternalKey(encrKey.getEphemeralKey(), encrKey.getId());
            dkSig.prepare((Document)doc, this.secHeader);
            dkSig.setParts(sigParts);
            dkSig.addReferencesToSign(sigParts, this.secHeader);
            dkSig.computeSignature();
            dkSig.appendDKElementToHeader(this.secHeader);
            dkSig.appendSigToHeader(this.secHeader);
            return dkSig.getSignatureValue();
        }
        AbstractBindingBuilder.WSSecSignatureHelper sig = this.getSignatureBuider(wrapper, token, false);
        if (sig != null) {
            sig.prependBSTElementToHeader(this.secHeader);
            sig.addReferencesToSign(sigParts, this.secHeader);
            this.insertBeforeBottomUp(sig.getSignatureElement());
            sig.computeSignature();
            return sig.getSignatureValue();
        }
        return null;
    }

    private byte[] doIssuedTokenSignature(Token token, SignedEncryptedParts signdParts, TokenWrapper wrapper, SecurityToken securityTok) throws Exception {
        SOAPPart doc = this.saaj.getSOAPPart();
        SecurityToken secTok = securityTok;
        if (secTok == null) {
            secTok = this.getSecurityToken();
        }
        SPConstants.IncludeTokenType inclusion = token.getInclusion();
        boolean tokenIncluded = false;
        Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS || (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE) && this.isRequestor()) {
            Element el = this.cloneElement(secTok.getToken());
            if (securityTok != null) {
                // empty if block
            }
            this.addEncyptedKeyElement(el);
            tokenIncluded = true;
        }
        if (this.timestampEl != null) {
            sigParts.add(new WSEncryptionPart(this.timestampEl.getId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                sigParts.add(new WSEncryptionPart(this.addWsuIdToElement((Element)this.saaj.getSOAPBody())));
            }
            if (secTok.getX509Certificate() != null || securityTok != null) {
                for (Header header : signdParts.getHeaders()) {
                    WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                    sigParts.add(wep);
                }
            }
        }
        AlgorithmSuite algorithmSuite = this.tbinding.getAlgorithmSuite();
        if (token.isDerivedKeys()) {
            WSSecDKSign dkSign = new WSSecDKSign();
            Element ref = tokenIncluded ? secTok.getAttachedReference() : secTok.getUnattachedReference();
            if (ref != null) {
                dkSign.setExternalKey(secTok.getSecret(), this.cloneElement(ref));
            } else {
                dkSign.setExternalKey(secTok.getSecret(), secTok.getId());
            }
            dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength() / 8);
            if (token.getSPConstants() == SP12Constants.INSTANCE) {
                dkSign.setWscVersion(2);
            }
            dkSign.prepare((Document)doc, this.secHeader);
            this.addDerivedKeyElement(dkSign.getdktElement());
            dkSign.setParts(sigParts);
            dkSign.addReferencesToSign(sigParts, this.secHeader);
            dkSign.computeSignature();
            dkSign.appendSigToHeader(this.secHeader);
            return dkSign.getSignatureValue();
        }
        WSSecSignature sig = new WSSecSignature();
        if (secTok.getTokenType() == null) {
            sig.setCustomTokenId(secTok.getId());
            sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            sig.setKeyIdentifierType(12);
        } else {
            String id = secTok.getWsuId();
            if (id == null) {
                sig.setCustomTokenId(secTok.getId());
                sig.setKeyIdentifierType(11);
            } else {
                sig.setCustomTokenId(secTok.getWsuId());
                sig.setKeyIdentifierType(9);
            }
            sig.setCustomTokenValueType(secTok.getTokenType());
            sig.setCustomTokenValueType(secTok.getTokenType());
            sig.setKeyIdentifierType(9);
        }
        Crypto crypto = null;
        if (secTok.getSecret() == null) {
            sig.setX509Certificate(secTok.getX509Certificate());
            crypto = secTok.getCrypto();
            String uname = crypto.getKeyStore().getCertificateAlias(secTok.getX509Certificate());
            String password = this.getPassword(uname, token, 3);
            if (password == null) {
                password = "";
            }
            sig.setUserInfo(uname, password);
            sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        } else {
            crypto = this.getSignatureCrypto(wrapper);
            sig.setSecretKey(secTok.getSecret());
            sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        }
        sig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
        sig.prepare((Document)doc, crypto, this.secHeader);
        sig.setParts(sigParts);
        sig.addReferencesToSign(sigParts, this.secHeader);
        sig.computeSignature();
        this.insertBeforeBottomUp(sig.getSignatureElement());
        return sig.getSignatureValue();
    }
}

