/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;

public class HasExecutionVariableCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;

    public HasExecutionVariableCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        boolean hasVariable = false;
        hasVariable = this.isLocal ? execution.hasVariableLocal(this.variableName) : execution.hasVariable(this.variableName);
        return hasVariable;
    }
}

