/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti.engine.impl.delegate.JavaDelegateInvocation;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        Object delegate = this.expression.getValue(execution);
        if (delegate instanceof SignallableActivityBehavior) {
            ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
            ((SignallableActivityBehavior)delegate).signal(execution, signalName, signalData);
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        block6: {
            try {
                Object delegate = this.expression.getValue(execution);
                ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
                if (delegate instanceof ActivityBehavior) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)delegate, execution));
                    break block6;
                }
                if (delegate instanceof JavaDelegate) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
                    this.leave(execution);
                    break block6;
                }
                throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
            }
            catch (Exception exc) {
                BpmnError error = null;
                for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BpmnError)) continue;
                    error = (BpmnError)cause;
                    break;
                }
                if (error != null) {
                    ErrorPropagation.propagateError(error, execution);
                }
                throw exc;
            }
        }
    }
}

