/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class MissingOverrideRule
extends AbstractJavaRule {
    private static final Logger LOG = Logger.getLogger(MissingOverrideRule.class.getName());
    private final Stack<MethodLookup> currentLookup = new Stack();

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.currentLookup.clear();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.currentLookup.push(this.getMethodLookup(node.getType()));
        super.visit(node, data);
        this.currentLookup.pop();
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.currentLookup.push(this.getMethodLookup(node.getType()));
        super.visit(node, data);
        this.currentLookup.pop();
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (node.isAnonymousClass()) {
            this.currentLookup.push(this.getMethodLookup(node.getType()));
        }
        super.visit(node, data);
        if (node.isAnonymousClass()) {
            this.currentLookup.pop();
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumConstant node, Object data) {
        super.visit(node, data);
        return data;
    }

    private MethodLookup getMethodLookup(Class<?> exploredType) {
        if (exploredType == null) {
            return null;
        }
        try {
            Set<Method> overridden = this.overriddenMethods(exploredType);
            HashMap result = new HashMap();
            for (Method m : exploredType.getDeclaredMethods()) {
                int paramCount;
                Map pCountToOverloads;
                if (!result.containsKey(m.getName())) {
                    result.put(m.getName(), new HashMap());
                }
                if (!(pCountToOverloads = (Map)result.get(m.getName())).containsKey(paramCount = m.getParameterTypes().length)) {
                    pCountToOverloads.put(paramCount, new ArrayList());
                }
                ((List)pCountToOverloads.get(paramCount)).add(m);
            }
            return new MethodLookup(result, overridden);
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private Set<Method> overriddenMethods(Class<?> exploredType) {
        return this.overriddenMethodsRec(exploredType, true, new HashSet<Method>(Arrays.asList(exploredType.getDeclaredMethods())), new HashSet<Method>(), new HashSet(), false);
    }

    private Set<Method> overriddenMethodsRec(Class<?> exploredType, boolean skip, Set<Method> candidates, Set<Method> result, Set<Class<?>> alreadyExplored, boolean onlyPublic) {
        if (candidates.isEmpty() || alreadyExplored.contains(exploredType)) {
            return result;
        }
        alreadyExplored.add(exploredType);
        if (!skip) {
            HashSet<Method> toRemove = new HashSet<Method>();
            for (GenericDeclaration genericDeclaration : exploredType.getDeclaredMethods()) {
                if (onlyPublic && !Modifier.isPublic(((Method)genericDeclaration).getModifiers()) || Modifier.isPrivate(((Method)genericDeclaration).getModifiers()) || Modifier.isStatic(((Method)genericDeclaration).getModifiers())) continue;
                for (Method cand : candidates) {
                    if (Modifier.isPrivate(((Method)genericDeclaration).getModifiers()) || Modifier.isStatic(((Method)genericDeclaration).getModifiers()) || !cand.getName().equals(((Method)genericDeclaration).getName()) || !Arrays.equals(cand.getParameterTypes(), ((Method)genericDeclaration).getParameterTypes())) continue;
                    result.add(cand);
                    toRemove.add(cand);
                }
                candidates.removeAll(toRemove);
            }
        }
        if (candidates.isEmpty()) {
            return result;
        }
        Class<?> superClass = exploredType.getSuperclass();
        if (superClass != null) {
            this.overriddenMethodsRec(superClass, false, candidates, result, alreadyExplored, false);
        }
        for (GenericDeclaration genericDeclaration : exploredType.getInterfaces()) {
            this.overriddenMethodsRec((Class<?>)genericDeclaration, false, candidates, result, alreadyExplored, false);
        }
        if (exploredType.isInterface() && exploredType.getInterfaces().length == 0 && !alreadyExplored.contains(Object.class)) {
            this.overriddenMethodsRec(Object.class, false, candidates, result, alreadyExplored, true);
        }
        return result;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.currentLookup.peek() == null) {
            return super.visit(node, data);
        }
        for (ASTAnnotation annot : node.getDeclaredAnnotations()) {
            if (!Override.class.equals(annot.getType())) continue;
            return super.visit(node, data);
        }
        try {
            boolean overridden = this.currentLookup.peek().isOverridden(node.getName(), node.getFormalParameters());
            if (overridden) {
                this.addViolation(data, node, new Object[]{node.getQualifiedName().getOperation()});
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warning("MissingOverride encountered unexpected method " + node.getMethodName());
        }
        return super.visit(node, data);
    }

    private static class MethodLookup {
        private final Map<String, Map<Integer, List<Method>>> map;
        private final Set<Method> overridden;

        private MethodLookup(Map<String, Map<Integer, List<Method>>> map, Set<Method> overridden) {
            this.map = map;
            this.overridden = overridden;
            for (Map<Integer, List<Method>> overloadSet : map.values()) {
                for (Map.Entry<Integer, List<Method>> sameParamCountMethods : overloadSet.entrySet()) {
                    this.resolveBridges(sameParamCountMethods.getValue());
                }
            }
        }

        private void resolveBridges(List<Method> overloads) {
            if (overloads.size() <= 1) {
                return;
            }
            ArrayList<Method> bridges = new ArrayList<Method>();
            ArrayList<Method> notBridges = new ArrayList<Method>();
            for (Method m : overloads) {
                if (m.isBridge()) {
                    bridges.add(m);
                    continue;
                }
                notBridges.add(m);
            }
            if (bridges.isEmpty()) {
                return;
            }
            if (notBridges.size() == bridges.size()) {
                this.overridden.addAll(notBridges);
            }
            overloads.removeAll(bridges);
        }

        private List<Method> getMethods(String name, int paramCount) throws NoSuchMethodException {
            Map<Integer, List<Method>> overloads = this.map.get(name);
            if (overloads == null) {
                throw new NoSuchMethodException(name);
            }
            List<Method> methods = overloads.get(paramCount);
            if (methods == null || methods.isEmpty()) {
                throw new NoSuchMethodException(name);
            }
            return methods;
        }

        boolean isOverridden(String name, ASTFormalParameters params) throws NoSuchMethodException {
            List<Method> methods = this.getMethods(name, params.getParameterCount());
            if (methods.size() == 1) {
                return this.overridden.contains(methods.get(0));
            }
            Object[] paramTypes = MethodLookup.getParameterTypes(params);
            if (paramTypes == null) {
                return false;
            }
            for (Method m : methods) {
                if (!Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                return this.overridden.contains(m);
            }
            return false;
        }

        private static Class<?>[] getParameterTypes(ASTFormalParameters params) {
            Class[] paramTypes = new Class[params.getParameterCount()];
            int i = 0;
            for (ASTFormalParameter p : params) {
                Class<?> pType = p.getType();
                if (pType == null) {
                    return null;
                }
                paramTypes[i++] = pType;
            }
            return paramTypes;
        }
    }
}

