/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.net.URI;
import java.net.URISyntaxException;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.access.ExpertFeature;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsControllerFilter;
import net.java.truevfs.kernel.spec.FsControllerSyncVisitor;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsSyncWarningException;
import net.java.truevfs.kernel.spec.FsUriModifier;

public final class TVFS {
    private TVFS() {
    }

    public static void umount() throws FsSyncWarningException, FsSyncException {
        TVFS.sync((BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile tree) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, (BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    public static void umount(FsMountPoint tree) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, (BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    static FsMountPoint mountPoint(TFile tree) {
        if (tree.isArchive()) {
            return tree.getController().getModel().getMountPoint();
        }
        try {
            return new FsMountPoint(new URI(tree.getFile().toURI() + "/"), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync((BitField<FsSyncOption>)FsSyncOptions.of((FsSyncOption[])options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync((Filter<? super FsController>)Filter.ACCEPT_ANY, options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, (BitField<FsSyncOption>)FsSyncOptions.of((FsSyncOption[])options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(TVFS.mountPoint(tree), options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, (BitField<FsSyncOption>)FsSyncOptions.of((FsSyncOption[])options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync((Filter<? super FsController>)new FsControllerFilter(tree), options);
    }

    private static void sync(Filter<? super FsController> filter, BitField<FsSyncOption> options) throws FsSyncException {
        TConfig.current().getManager().sync(filter, (Visitor)new FsControllerSyncVisitor(options));
    }
}

