/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.struct;

import javax.annotation.Nullable;
import net.dongliu.requests.struct.AuthInfo;
import org.apache.http.annotation.Immutable;

@Immutable
public class Proxy {
    private final String scheme;
    private final String host;
    private final int port;
    @Nullable
    private final AuthInfo authInfo;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String SOCKS = "socks";

    private Proxy(String scheme, String host, int port, @Nullable AuthInfo authInfo) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.authInfo = authInfo;
    }

    public static Proxy httpProxy(String host, int port) {
        return new Proxy(HTTP, host, port, null);
    }

    public static Proxy httpProxy(String host, int port, String userName, String password) {
        return new Proxy(HTTP, host, port, new AuthInfo(userName, password));
    }

    public static Proxy socksProxy(String host, int port) {
        return new Proxy(SOCKS, host, port, null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getScheme() {
        return this.scheme;
    }
}

