/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.dongliu.requests.Client;
import net.dongliu.requests.IBaseRequestBuilder;
import net.dongliu.requests.RawResponse;
import net.dongliu.requests.Request;
import net.dongliu.requests.Session;
import net.dongliu.requests.exception.UncheckedURISyntaxException;
import net.dongliu.requests.struct.AuthInfo;
import net.dongliu.requests.struct.Method;

public abstract class RequestBuilder<T extends RequestBuilder<T>>
implements IBaseRequestBuilder<T> {
    private Client client;
    protected Method method;
    protected URI url;
    @Nullable
    protected Collection<? extends Map.Entry<String, String>> parameters;
    @Nullable
    protected Collection<? extends Map.Entry<String, String>> headers;
    @Nullable
    protected Collection<? extends Map.Entry<String, String>> cookies;
    protected Charset charset = StandardCharsets.UTF_8;
    @Nullable
    protected AuthInfo authInfo;
    @Nullable
    protected Session session;

    public RawResponse send() throws UncheckedIOException {
        Request request = this.build();
        return this.client.execute(request, this.session);
    }

    T client(Client client) {
        this.client = client;
        return this.self();
    }

    T url(String url) throws UncheckedIOException {
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
        return this.self();
    }

    public abstract Request build();

    @Override
    public T params(Collection<? extends Map.Entry<String, String>> params) {
        this.parameters = Objects.requireNonNull(params);
        return this.self();
    }

    @Override
    public T requestCharset(Charset charset) {
        this.charset = charset;
        return this.self();
    }

    T method(Method method) {
        this.method = method;
        return this.self();
    }

    @Override
    public T headers(Collection<? extends Map.Entry<String, String>> headers) {
        this.headers = Objects.requireNonNull(headers);
        return this.self();
    }

    @Override
    public T basicAuth(String userName, String password) {
        this.authInfo = new AuthInfo(userName, password);
        return this.self();
    }

    @Override
    public T cookies(Collection<? extends Map.Entry<String, String>> cookies) {
        this.cookies = cookies;
        return this.self();
    }

    T session(Session session) {
        this.session = session;
        return this.self();
    }

    protected abstract T self();
}

