/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.dongliu.requests.Client;
import net.dongliu.requests.IOUtils;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.exception.IllegalStatusException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;

public class RawResponse
implements Closeable {
    private final CloseableHttpResponse closeableHttpResponse;
    private final Client client;
    private final boolean closeOnFinished;
    private final int status;
    private final List<Header> headers;
    private final List<Cookie> cookies;
    private final List<URI> redirectLocations;
    @Nullable
    private Charset charset;

    RawResponse(CloseableHttpResponse closeableHttpResponse, Client client, boolean closeOnFinished, int status, List<Header> headers, List<Cookie> cookies, @Nullable List<URI> redirectLocations) {
        this.closeableHttpResponse = closeableHttpResponse;
        this.client = client;
        this.closeOnFinished = closeOnFinished;
        this.status = status;
        this.headers = Collections.unmodifiableList(headers);
        this.cookies = Collections.unmodifiableList(cookies);
        this.redirectLocations = redirectLocations == null ? Collections.emptyList() : Collections.unmodifiableList(redirectLocations);
    }

    public RawResponse checkStatusValid() throws IllegalStatusException {
        if (this.status < 200 || this.status >= 400) {
            this.close();
            throw new IllegalStatusException(this.status);
        }
        return this;
    }

    public RawResponse checkStatus2xx() throws IllegalStatusException {
        if (this.status < 200 || this.status >= 300) {
            this.close();
            throw new IllegalStatusException(this.status);
        }
        return this;
    }

    public RawResponse responseCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <R> R process(ResponseProcessor<R> processor) throws UncheckedIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public <T> T unmarshalBin(Function<InputStream, T> function) {
        this.checkStatus2xx();
        return (T)this.process(resp -> function.apply(resp.getIn()));
    }

    @Nullable
    public <T> T unmarshalText(Function<Reader, T> function) {
        this.checkStatus2xx();
        return (T)this.process(resp -> {
            try (InputStreamReader reader = new InputStreamReader(resp.getIn(), this.getCharset());){
                Object r = function.apply(reader);
                return r;
            }
        });
    }

    public String readToText() throws UncheckedIOException {
        String str = this.process(respData -> IOUtils.toString(new InputStreamReader(respData.getIn(), this.getCharset()), Math.toIntExact(this.byteLen2CharLen(respData.getContentLen()))));
        return str == null ? "" : str;
    }

    private long byteLen2CharLen(long byteLen) {
        if (byteLen < 0L) {
            return byteLen;
        }
        if (byteLen < 8192L) {
            return byteLen;
        }
        return (long)((double)byteLen / 1.5);
    }

    public byte[] readToBytes() throws UncheckedIOException {
        byte[] bytes = this.process(respData -> IOUtils.toBytes(respData.getIn(), Math.toIntExact(respData.getContentLen())));
        return bytes == null ? new byte[]{} : IOUtils.emptyByteArray;
    }

    public boolean writeTo(File file) throws UncheckedIOException {
        Boolean result = this.process(responseData -> {
            try (FileOutputStream out = new FileOutputStream(file);){
                IOUtils.copy(responseData.getIn(), out, responseData.getContentLen());
            }
            return true;
        });
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean writeTo(OutputStream out) throws UncheckedIOException {
        Boolean result = this.process(responseData -> {
            IOUtils.copy(responseData.getIn(), out, responseData.getContentLen());
            return true;
        });
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean writeTo(Writer writer) {
        Boolean result = this.process(respData -> {
            IOUtils.copy(new InputStreamReader(respData.getIn(), this.getCharset()), writer, this.byteLen2CharLen(respData.getContentLen()));
            return true;
        });
        if (result == null) {
            return false;
        }
        return result;
    }

    private Charset getCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        ContentType contentType = ContentType.get((HttpEntity)this.closeableHttpResponse.getEntity());
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }

    public int getStatus() {
        return this.status;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Nullable
    public String getFirstHeader(String name) {
        return this.headers.stream().filter(h -> h.getName().equals(name)).findFirst().map(Header::getValue).orElse(null);
    }

    public List<String> getHeaders(String name) {
        return this.headers.stream().filter(h -> h.getName().equals(name)).map(Header::getValue).collect(Collectors.toList());
    }

    @Nullable
    public Cookie getFirstCookie(String name) {
        return this.cookies.stream().filter(h -> h.getName().equals(name)).findFirst().orElse(null);
    }

    public List<Cookie> getCookies(String name) {
        return this.cookies.stream().filter(h -> h.getName().equals(name)).collect(Collectors.toList());
    }

    public List<URI> getRedirectLocations() {
        return this.redirectLocations;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.closeableHttpResponse);
        if (this.closeOnFinished) {
            this.client.close();
        }
    }
}

