/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.dongliu.requests.ClientBuilder;
import net.dongliu.requests.struct.Host;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class PooledClientBuilder
extends ClientBuilder<PooledClientBuilder> {
    private int maxTotal = 20;
    private int maxPerRoute = 5;
    private Map<Host, Integer> perRouteCount;

    PooledClientBuilder() {
    }

    public PooledClientBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public PooledClientBuilder maxPerRoute(int maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
        return this;
    }

    public PooledClientBuilder maxPerRoute(Host host, int maxPerRoute) {
        this.ensurePerRouteCount();
        this.perRouteCount.put(host, maxPerRoute);
        return this;
    }

    private void ensurePerRouteCount() {
        if (this.perRouteCount == null) {
            this.perRouteCount = new HashMap<Host, Integer>();
        }
    }

    @Override
    protected PooledClientBuilder self() {
        return this;
    }

    @Override
    protected HttpClientConnectionManager buildManager(Registry<ConnectionSocketFactory> registry) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry, null, null, null, this.timeToLive, TimeUnit.MILLISECONDS);
        manager.setMaxTotal(this.maxTotal);
        manager.setDefaultMaxPerRoute(this.maxPerRoute);
        if (this.perRouteCount != null) {
            for (Map.Entry<Host, Integer> pair : this.perRouteCount.entrySet()) {
                Host host = pair.getKey();
                manager.setMaxPerRoute(new HttpRoute(new HttpHost(host.getDomain(), host.getPort())), pair.getValue().intValue());
            }
        }
        return manager;
    }
}

