/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.annotation.Nullable;

class IOUtils {
    static final byte[] emptyByteArray = new byte[0];

    IOUtils() {
    }

    static void copy(InputStream in, OutputStream out, long expectSize) {
        int bufferSize = 8192;
        if (expectSize > 0L && expectSize < (long)bufferSize) {
            bufferSize = (int)expectSize;
        }
        try {
            int len;
            byte[] buffer = new byte[bufferSize];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    static void copy(Reader reader, Writer writer, long expectSize) {
        int bufferSize = 4096;
        if (expectSize > 0L && expectSize < (long)bufferSize) {
            bufferSize = (int)expectSize;
        }
        try {
            int len;
            char[] buffer = new char[bufferSize];
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String toString(Reader reader, int expectSize) {
        try (StringWriter writer = expectSize > 0 ? new StringWriter(expectSize) : new StringWriter(512);){
            IOUtils.copy(reader, writer, (long)expectSize);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(InputStream in, int expectSize) {
        try (ByteArrayOutputStream os = expectSize > 0 ? new ByteArrayOutputStream(expectSize) : new ByteArrayOutputStream(1024);){
            IOUtils.copy(in, os, (long)expectSize);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

