/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.dongliu.requests.BodyRequestBuilder;
import net.dongliu.requests.HeadOnlyRequestBuilder;
import net.dongliu.requests.PooledClientBuilder;
import net.dongliu.requests.PostRequestBuilder;
import net.dongliu.requests.RawResponse;
import net.dongliu.requests.Request;
import net.dongliu.requests.Session;
import net.dongliu.requests.SingleClientBuilder;
import net.dongliu.requests.exception.UncheckedURISyntaxException;
import net.dongliu.requests.struct.AuthInfo;
import net.dongliu.requests.struct.HttpBody;
import net.dongliu.requests.struct.Method;
import net.dongliu.requests.struct.Proxy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;

public class Client
implements Closeable {
    private final CloseableHttpClient client;
    private final boolean closeOnFinished;
    @Nullable
    private final Proxy proxy;
    private AuthInfo authInfo;

    public Client(CloseableHttpClient client, boolean closeOnFinished, Proxy proxy) {
        this.client = client;
        this.closeOnFinished = closeOnFinished;
        this.proxy = proxy;
    }

    public static PooledClientBuilder pooled() {
        return new PooledClientBuilder();
    }

    public static SingleClientBuilder single() {
        return new SingleClientBuilder();
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HeadOnlyRequestBuilder get(String url) throws UncheckedIOException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.GET)).url(url);
    }

    public HeadOnlyRequestBuilder head(String url) throws UncheckedIOException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.HEAD)).url(url);
    }

    public PostRequestBuilder post(String url) throws UncheckedIOException {
        return (PostRequestBuilder)((PostRequestBuilder)((PostRequestBuilder)new PostRequestBuilder().client(this)).method(Method.POST)).url(url);
    }

    public BodyRequestBuilder put(String url) throws UncheckedIOException {
        return (BodyRequestBuilder)((BodyRequestBuilder)((BodyRequestBuilder)new BodyRequestBuilder().client(this)).method(Method.PUT)).url(url);
    }

    public HeadOnlyRequestBuilder delete(String url) throws UncheckedIOException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.DELETE)).url(url);
    }

    public HeadOnlyRequestBuilder options(String url) throws UncheckedIOException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.OPTIONS)).url(url);
    }

    public BodyRequestBuilder patch(String url) throws UncheckedIOException {
        return (BodyRequestBuilder)((BodyRequestBuilder)((BodyRequestBuilder)new BodyRequestBuilder().client(this)).method(Method.PATCH)).url(url);
    }

    public HeadOnlyRequestBuilder trace(String url) throws UncheckedIOException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.TRACE)).url(url);
    }

    public Session session() {
        return new Session(this);
    }

    RawResponse execute(Request request, @Nullable Session session) throws UncheckedIOException {
        CloseableHttpResponse httpResponse;
        AuthInfo proxyAuthInfo;
        HttpClientContext context;
        if (session != null) {
            context = session.getContext();
        } else {
            context = HttpClientContext.create();
            BasicCookieStore cookieStore = new BasicCookieStore();
            context.setCookieStore((CookieStore)cookieStore);
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        HttpRequestBase httpRequest = this.buildRequest(request, context);
        if (request.getAuthInfo() != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(request.getAuthInfo().getUserName(), request.getAuthInfo().getPassword());
            provider.setCredentials(new AuthScope(request.getUrl().getHost(), request.getUrl().getPort()), (Credentials)credentials);
        }
        if (this.proxy != null && this.proxy.getScheme().equals("http") && (proxyAuthInfo = this.proxy.getAuthInfo()) != null) {
            provider.setCredentials(new AuthScope(this.proxy.getHost(), this.proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxyAuthInfo.getUserName(), proxyAuthInfo.getUserName()));
        }
        context.setAttribute("http.auth.credentials-provider", (Object)provider);
        try {
            httpResponse = this.client.execute((HttpUriRequest)httpRequest, (HttpContext)context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        List<Header> headers = Arrays.asList(httpResponse.getAllHeaders());
        List cookies = context.getCookieStore().getCookies();
        List history = context.getRedirectLocations();
        return new RawResponse(httpResponse, this, this.closeOnFinished, statusCode, headers, cookies, history);
    }

    private HttpRequestBase buildRequest(Request request, HttpClientContext context) {
        HttpPost httpRequest;
        URI uri = this.buildUrl(request.getUrl(), request.getCharset(), request.getParameters());
        switch (request.getMethod()) {
            case POST: {
                httpRequest = this.buildHttpPost(uri, request);
                break;
            }
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(uri);
                break;
            }
            case PUT: {
                httpRequest = this.buildHttpPut(uri, request);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions(uri);
                break;
            }
            case TRACE: {
                httpRequest = new HttpTrace(uri);
                break;
            }
            case PATCH: {
                httpRequest = this.buildHttpPatch(uri, request);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported method:" + (Object)((Object)request.getMethod()));
            }
        }
        CookieStore cookieStore = context.getCookieStore();
        if (request.getCookies() != null) {
            for (Map.Entry<String, String> entry : request.getCookies()) {
                BasicClientCookie clientCookie = new BasicClientCookie(entry.getKey(), entry.getValue());
                clientCookie.setDomain(request.getUrl().getHost());
                clientCookie.setPath("/");
                cookieStore.addCookie((Cookie)clientCookie);
            }
        }
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders()) {
                httpRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpRequest;
    }

    private HttpRequestBase buildHttpPut(URI uri, Request request) {
        HttpPut httpPut = new HttpPut(uri);
        HttpBody body = request.getHttpBody();
        if (body != null) {
            HttpEntity entity = body.createEntity(request.getCharset());
            httpPut.setEntity(entity);
        }
        return httpPut;
    }

    private HttpPost buildHttpPost(URI uri, Request request) {
        HttpPost httpPost = new HttpPost(uri);
        HttpBody body = request.getHttpBody();
        if (body != null) {
            HttpEntity entity = body.createEntity(request.getCharset());
            httpPost.setEntity(entity);
        }
        return httpPost;
    }

    private HttpRequestBase buildHttpPatch(URI uri, Request request) {
        HttpPatch httpPatch = new HttpPatch(uri);
        HttpBody body = request.getHttpBody();
        if (body != null) {
            HttpEntity entity = body.createEntity(request.getCharset());
            httpPatch.setEntity(entity);
        }
        return httpPatch;
    }

    private URI buildUrl(URI url, Charset charset, @Nullable Collection<? extends Map.Entry<String, String>> parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return url;
            }
            URIBuilder urlBuilder = new URIBuilder(url).setCharset(charset);
            for (Map.Entry<String, String> entry : parameters) {
                urlBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            return urlBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }
}

