/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.GdiPen;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import org.w3c.dom.Text;

class SvgPen
extends SvgObject
implements GdiPen {
    private int style;
    private int width;
    private int color;

    public SvgPen(SvgGdi svgGdi, int n, int n2, int n3) {
        super(svgGdi);
        this.style = n;
        this.width = n2 > 0 ? n2 : 1;
        this.color = n3;
    }

    public int getStyle() {
        return this.style;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColor() {
        return this.color;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.color;
        n = 31 * n + this.style;
        n = 31 * n + this.width;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SvgPen svgPen = (SvgPen)object;
        if (this.color != svgPen.color) {
            return false;
        }
        if (this.style != svgPen.style) {
            return false;
        }
        return this.width == svgPen.width;
    }

    public Text createTextNode(String string) {
        return this.getGDI().getDocument().createTextNode("." + string + " { " + this.toString() + " }\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.style == 5) {
            stringBuffer.append("stroke: none; ");
        } else {
            stringBuffer.append("stroke: " + SvgPen.toColor(this.color) + "; ");
            stringBuffer.append("stroke-width: " + this.width + "; ");
            stringBuffer.append("stroke-linejoin: round; ");
            if (this.width == 1 && 1 <= this.style && this.style <= 4) {
                stringBuffer.append("stroke-dasharray: ");
                switch (this.style) {
                    case 1: {
                        stringBuffer.append("" + this.toRealSize(18) + "," + this.toRealSize(6));
                        break;
                    }
                    case 2: {
                        stringBuffer.append("" + this.toRealSize(3) + "," + this.toRealSize(3));
                        break;
                    }
                    case 3: {
                        stringBuffer.append("" + this.toRealSize(9) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3));
                        break;
                    }
                    case 4: {
                        stringBuffer.append("" + this.toRealSize(9) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3));
                    }
                }
                stringBuffer.append("; ");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

