/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerResponseMessageReader(TypeNameExtractor typeNameExtractor, TypeResolver typeResolver) {
        this.typeNameExtractor = typeNameExtractor;
        this.typeResolver = typeResolver;
    }

    public void apply(OperationContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        context.operationBuilder().responseMessages(this.read(handlerMethod, context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<ResponseMessage> read(HandlerMethod handlerMethod, OperationContext context) {
        ResolvedType defaultResponse = new HandlerMethodResolver(this.typeResolver).methodReturnType(handlerMethod);
        Optional<ApiOperation> operationAnnotation = Annotations.findApiOperationAnnotation(handlerMethod.getMethod());
        Optional operationResponse = operationAnnotation.transform(Annotations.resolvedTypeFromOperation(this.typeResolver, defaultResponse));
        Optional defaultResponseHeaders = operationAnnotation.transform(ResponseHeaders.resposeHeaders());
        HashMap defaultHeaders = Maps.newHashMap();
        if (defaultResponseHeaders.isPresent()) {
            defaultHeaders.putAll(ResponseHeaders.headers((ResponseHeader[])defaultResponseHeaders.get()));
        }
        Optional<ApiResponses> apiResponses = Annotations.findApiResponsesAnnotations(handlerMethod.getMethod());
        HashSet responseMessages = Sets.newHashSet();
        if (apiResponses.isPresent()) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = ((ApiResponses)apiResponses.get()).value()) {
                ModelContext modelContext = ModelContext.returnValue((Type)apiResponse.response(), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
                Optional responseModel = Optional.absent();
                Optional type = this.resolvedType(null, apiResponse);
                if (SwaggerResponseMessageReader.isSuccessful(apiResponse.code())) {
                    type = type.or(operationResponse);
                }
                if (type.isPresent()) {
                    responseModel = Optional.of((Object)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.typeNameExtractor).apply((Object)context.alternateFor((ResolvedType)type.get())));
                }
                HashMap headers = Maps.newHashMap((Map)defaultHeaders);
                headers.putAll(ResponseHeaders.headers(apiResponse.responseHeaders()));
                responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel((ModelReference)responseModel.orNull()).headers((Map)headers).build());
            }
        }
        if (operationResponse.isPresent()) {
            ModelContext modelContext = ModelContext.returnValue((Type)((Type)operationResponse.get()), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
            ResolvedType resolvedType = context.alternateFor((ResolvedType)operationResponse.get());
            ModelReference responseModel = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.typeNameExtractor).apply((Object)resolvedType);
            context.operationBuilder().responseModel(responseModel);
            ResponseMessage defaultMessage = new ResponseMessageBuilder().code(ResponseMessagesReader.httpStatusCode((HandlerMethod)handlerMethod)).message(ResponseMessagesReader.message((HandlerMethod)handlerMethod)).responseModel(responseModel).build();
            if (!responseMessages.contains(defaultMessage) && !"void".equals(responseModel.getType())) {
                responseMessages.add(defaultMessage);
            }
        }
        return responseMessages;
    }

    static boolean isSuccessful(int code) {
        return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf((int)code));
    }

    private Optional<ResolvedType> resolvedType(ResolvedType resolvedType, ApiResponse apiResponse) {
        return Optional.fromNullable((Object)Annotations.resolvedTypeFromResponse(this.typeResolver, resolvedType).apply((Object)apiResponse));
    }
}

