/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.annotations;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;

public class Annotations {
    private Annotations() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ApiParam> findApiParamAnnotation(AnnotatedElement annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiParam.class));
    }

    public static Optional<ApiOperation> findApiOperationAnnotation(Method annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)annotated, ApiOperation.class));
    }

    public static Optional<ApiResponses> findApiResponsesAnnotations(Method annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)annotated, ApiResponses.class));
    }

    public static Optional<ResponseHeader> findResponseHeader(Method annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)annotated, ResponseHeader.class));
    }

    public static Function<ApiOperation, ResolvedType> resolvedTypeFromOperation(final TypeResolver typeResolver, final ResolvedType defaultType) {
        return new Function<ApiOperation, ResolvedType>(){

            public ResolvedType apply(ApiOperation annotation) {
                return Annotations.getResolvedType(annotation, typeResolver, defaultType);
            }
        };
    }

    public static Function<ApiResponse, ResolvedType> resolvedTypeFromResponse(final TypeResolver typeResolver, final ResolvedType defaultType) {
        return new Function<ApiResponse, ResolvedType>(){

            public ResolvedType apply(ApiResponse annotation) {
                return Annotations.getResolvedType(annotation, typeResolver, defaultType);
            }
        };
    }

    @VisibleForTesting
    static ResolvedType getResolvedType(ApiOperation annotation, TypeResolver typeResolver, ResolvedType defaultType) {
        if (null != annotation && Void.class != annotation.response()) {
            if ("List".compareToIgnoreCase(annotation.responseContainer()) == 0) {
                return typeResolver.resolve(List.class, new Type[]{annotation.response()});
            }
            if ("Set".compareToIgnoreCase(annotation.responseContainer()) == 0) {
                return typeResolver.resolve(Set.class, new Type[]{annotation.response()});
            }
            return typeResolver.resolve((Type)annotation.response(), new Type[0]);
        }
        return defaultType;
    }

    @VisibleForTesting
    static ResolvedType getResolvedType(ApiResponse annotation, TypeResolver typeResolver, ResolvedType defaultType) {
        if (null != annotation && Void.class != annotation.response()) {
            if ("List".compareToIgnoreCase(annotation.responseContainer()) == 0) {
                return typeResolver.resolve(List.class, new Type[]{annotation.response()});
            }
            if ("Set".compareToIgnoreCase(annotation.responseContainer()) == 0) {
                return typeResolver.resolve(Set.class, new Type[]{annotation.response()});
            }
            return typeResolver.resolve((Type)annotation.response(), new Type[0]);
        }
        return defaultType;
    }
}

