/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.complex;

import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.complex.CartesianDataSource;
import io.shardingjdbc.core.routing.type.complex.CartesianTableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class CartesianRoutingResult
extends RoutingResult {
    private final List<CartesianDataSource> routingDataSources = new ArrayList<CartesianDataSource>();

    void merge(String dataSource, Collection<CartesianTableReference> routingTableReferences) {
        for (CartesianTableReference each : routingTableReferences) {
            this.merge(dataSource, each);
        }
    }

    private void merge(String dataSource, CartesianTableReference routingTableReference) {
        for (CartesianDataSource each : this.routingDataSources) {
            if (!each.getDataSource().equalsIgnoreCase(dataSource)) continue;
            each.getRoutingTableReferences().add(routingTableReference);
            return;
        }
        this.routingDataSources.add(new CartesianDataSource(dataSource, routingTableReference));
    }

    @Override
    public boolean isSingleRouting() {
        LinkedList<CartesianTableReference> cartesianTableReferences = new LinkedList<CartesianTableReference>();
        for (CartesianDataSource cartesianDataSource : this.routingDataSources) {
            for (CartesianTableReference cartesianTableReference : cartesianDataSource.getRoutingTableReferences()) {
                cartesianTableReferences.add(cartesianTableReference);
            }
        }
        return 1 == cartesianTableReferences.size();
    }

    public String toString() {
        return "CartesianRoutingResult(routingDataSources=" + this.getRoutingDataSources() + ")";
    }

    public List<CartesianDataSource> getRoutingDataSources() {
        return this.routingDataSources;
    }
}

