/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.strategy;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.routing.strategy.ShardingAlgorithm;

public final class ShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass) {
        try {
            Class<?> result = Class.forName(shardingAlgorithmClassName);
            if (!superShardingAlgorithmClass.isAssignableFrom(result)) {
                throw new ShardingJdbcException("Class %s should be implement %s", shardingAlgorithmClassName, superShardingAlgorithmClass.getName());
            }
            return (T)((ShardingAlgorithm)result.newInstance());
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingJdbcException("Class %s should have public privilege and no argument constructor", shardingAlgorithmClassName);
        }
    }

    private ShardingAlgorithmFactory() {
    }
}

