/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rewrite;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.parsing.parser.token.IndexToken;
import io.shardingjdbc.core.parsing.parser.token.ItemsToken;
import io.shardingjdbc.core.parsing.parser.token.OffsetToken;
import io.shardingjdbc.core.parsing.parser.token.OrderByToken;
import io.shardingjdbc.core.parsing.parser.token.RowCountToken;
import io.shardingjdbc.core.parsing.parser.token.SQLToken;
import io.shardingjdbc.core.parsing.parser.token.TableToken;
import io.shardingjdbc.core.rewrite.SQLBuilder;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.routing.type.complex.CartesianTableReference;
import io.shardingjdbc.core.rule.BindingTableRule;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLRewriteEngine {
    private final ShardingRule shardingRule;
    private final String originalSQL;
    private final DatabaseType databaseType;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLStatement sqlStatement;

    public SQLRewriteEngine(ShardingRule shardingRule, String originalSQL, DatabaseType databaseType, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.originalSQL = originalSQL;
        this.databaseType = databaseType;
        this.sqlStatement = sqlStatement;
        this.sqlTokens.addAll(sqlStatement.getSqlTokens());
    }

    public SQLBuilder rewrite(boolean isRewriteLimit) {
        SQLBuilder result = new SQLBuilder();
        if (this.sqlTokens.isEmpty()) {
            result.appendLiterals(this.originalSQL);
            return result;
        }
        int count = 0;
        this.sortByBeginPosition();
        for (SQLToken each : this.sqlTokens) {
            if (0 == count) {
                result.appendLiterals(this.originalSQL.substring(0, each.getBeginPosition()));
            }
            if (each instanceof TableToken) {
                this.appendTableToken(result, (TableToken)each, count, this.sqlTokens);
            } else if (each instanceof IndexToken) {
                this.appendIndexToken(result, (IndexToken)each, count, this.sqlTokens);
            } else if (each instanceof ItemsToken) {
                this.appendItemsToken(result, (ItemsToken)each, count, this.sqlTokens);
            } else if (each instanceof RowCountToken) {
                this.appendLimitRowCount(result, (RowCountToken)each, count, this.sqlTokens, isRewriteLimit);
            } else if (each instanceof OffsetToken) {
                this.appendLimitOffsetToken(result, (OffsetToken)each, count, this.sqlTokens, isRewriteLimit);
            } else if (each instanceof OrderByToken) {
                this.appendOrderByToken(result, count, this.sqlTokens);
            }
            ++count;
        }
        return result;
    }

    private void sortByBeginPosition() {
        Collections.sort(this.sqlTokens, new Comparator<SQLToken>(){

            @Override
            public int compare(SQLToken o1, SQLToken o2) {
                return o1.getBeginPosition() - o2.getBeginPosition();
            }
        });
    }

    private void appendTableToken(SQLBuilder sqlBuilder, TableToken tableToken, int count, List<SQLToken> sqlTokens) {
        sqlBuilder.appendTable(tableToken.getTableName().toLowerCase());
        int beginPosition = tableToken.getBeginPosition() + tableToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendIndexToken(SQLBuilder sqlBuilder, IndexToken indexToken, int count, List<SQLToken> sqlTokens) {
        String indexName = indexToken.getIndexName().toLowerCase();
        String logicTableName = indexToken.getTableName().toLowerCase();
        if (Strings.isNullOrEmpty((String)logicTableName)) {
            logicTableName = this.shardingRule.getLogicTableName(indexName);
        }
        sqlBuilder.appendIndex(indexName, logicTableName);
        int beginPosition = indexToken.getBeginPosition() + indexToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendItemsToken(SQLBuilder sqlBuilder, ItemsToken itemsToken, int count, List<SQLToken> sqlTokens) {
        for (String item : itemsToken.getItems()) {
            sqlBuilder.appendLiterals(", ");
            sqlBuilder.appendLiterals(SQLUtil.getOriginalValue(item, this.databaseType));
        }
        int beginPosition = itemsToken.getBeginPosition();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendLimitRowCount(SQLBuilder sqlBuilder, RowCountToken rowCountToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        Limit limit = selectStatement.getLimit();
        if (!isRewrite) {
            sqlBuilder.appendLiterals(String.valueOf(rowCountToken.getRowCount()));
        } else if (!(selectStatement.getGroupByItems().isEmpty() && selectStatement.getAggregationSelectItems().isEmpty() || selectStatement.isSameGroupByAndOrderByItems())) {
            sqlBuilder.appendLiterals(String.valueOf(Integer.MAX_VALUE));
        } else {
            sqlBuilder.appendLiterals(String.valueOf(limit.isNeedRewriteRowCount() ? rowCountToken.getRowCount() + limit.getOffsetValue() : rowCountToken.getRowCount()));
        }
        int beginPosition = rowCountToken.getBeginPosition() + String.valueOf(rowCountToken.getRowCount()).length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendLimitOffsetToken(SQLBuilder sqlBuilder, OffsetToken offsetToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        sqlBuilder.appendLiterals(isRewrite ? "0" : String.valueOf(offsetToken.getOffset()));
        int beginPosition = offsetToken.getBeginPosition() + String.valueOf(offsetToken.getOffset()).length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendOrderByToken(SQLBuilder sqlBuilder, int count, List<SQLToken> sqlTokens) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        StringBuilder orderByLiterals = new StringBuilder();
        orderByLiterals.append(" ").append(DefaultKeyword.ORDER).append(" ").append(DefaultKeyword.BY).append(" ");
        int i = 0;
        for (OrderItem each : selectStatement.getOrderByItems()) {
            String columnLabel = SQLUtil.getOriginalValue(each.getColumnLabel(), this.databaseType);
            if (0 == i) {
                orderByLiterals.append(columnLabel).append(" ").append(each.getType().name());
            } else {
                orderByLiterals.append(",").append(columnLabel).append(" ").append(each.getType().name());
            }
            ++i;
        }
        orderByLiterals.append(" ");
        sqlBuilder.appendLiterals(orderByLiterals.toString());
        int beginPosition = ((SelectStatement)this.sqlStatement).getGroupByLastPosition();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendRest(SQLBuilder sqlBuilder, int count, List<SQLToken> sqlTokens, int beginPosition) {
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    public String generateSQL(TableUnit tableUnit, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(tableUnit));
    }

    public String generateSQL(CartesianTableReference cartesianTableReference, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(cartesianTableReference));
    }

    private Map<String, String> getTableTokens(TableUnit tableUnit) {
        String logicTableName = tableUnit.getLogicTableName().toLowerCase();
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        tableTokens.put(logicTableName, tableUnit.getActualTableName());
        Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(logicTableName);
        if (bindingTableRule.isPresent()) {
            tableTokens.putAll(this.getBindingTableTokens(tableUnit, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getTableTokens(CartesianTableReference cartesianTableReference) {
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        for (TableUnit each : cartesianTableReference.getTableUnits()) {
            String logicTableName = each.getLogicTableName().toLowerCase();
            tableTokens.put(logicTableName, each.getActualTableName());
            Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(logicTableName);
            if (!bindingTableRule.isPresent()) continue;
            tableTokens.putAll(this.getBindingTableTokens(each, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getBindingTableTokens(TableUnit tableUnit, BindingTableRule bindingTableRule) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String eachTable : this.sqlStatement.getTables().getTableNames()) {
            String tableName = eachTable.toLowerCase();
            if (tableName.equals(tableUnit.getLogicTableName().toLowerCase()) || !bindingTableRule.hasLogicTable(tableName)) continue;
            result.put(tableName, bindingTableRule.getBindingActualTable(tableUnit.getDataSourceName(), tableName, tableUnit.getActualTableName()));
        }
        return result;
    }
}

