/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dml.insert;

import com.google.common.base.Optional;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.context.GeneratedKey;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.context.condition.Condition;
import io.shardingjdbc.core.parsing.parser.context.condition.Conditions;
import io.shardingjdbc.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingjdbc.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingjdbc.core.parsing.parser.token.GeneratedKeyToken;
import io.shardingjdbc.core.parsing.parser.token.ItemsToken;
import io.shardingjdbc.core.parsing.parser.token.SQLToken;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.rule.TableRule;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class InsertStatement
extends DMLStatement {
    private final Collection<Column> columns = new LinkedList<Column>();
    private final List<Conditions> multipleConditions = new LinkedList<Conditions>();
    private int columnsListLastPosition;
    private int generateKeyColumnIndex = -1;
    private int afterValuesPosition;
    private int valuesListLastPosition;
    private GeneratedKey generatedKey;

    public void appendGenerateKeyToken(ShardingRule shardingRule, int parametersSize) {
        if (null != this.generatedKey) {
            return;
        }
        Optional<TableRule> tableRule = shardingRule.tryFindTableRule(this.getTables().getSingleTableName());
        if (!tableRule.isPresent()) {
            return;
        }
        Optional<GeneratedKeyToken> generatedKeysToken = this.findGeneratedKeyToken();
        if (!generatedKeysToken.isPresent()) {
            return;
        }
        ItemsToken valuesToken = new ItemsToken(((GeneratedKeyToken)generatedKeysToken.get()).getBeginPosition());
        if (0 == parametersSize) {
            this.appendGenerateKeyToken(shardingRule, (TableRule)tableRule.get(), valuesToken);
        } else {
            this.appendGenerateKeyToken(shardingRule, (TableRule)tableRule.get(), valuesToken, parametersSize);
        }
        this.getSqlTokens().remove(generatedKeysToken.get());
        this.getSqlTokens().add(valuesToken);
    }

    private void appendGenerateKeyToken(ShardingRule shardingRule, TableRule tableRule, ItemsToken valuesToken) {
        Number generatedKey = shardingRule.generateKey(tableRule.getLogicTable());
        valuesToken.getItems().add(generatedKey.toString());
        this.getConditions().add(new Condition(new Column(tableRule.getGenerateKeyColumn(), tableRule.getLogicTable()), new SQLNumberExpression(generatedKey)), shardingRule);
        this.generatedKey = new GeneratedKey(tableRule.getLogicTable(), -1, generatedKey);
    }

    private void appendGenerateKeyToken(ShardingRule shardingRule, TableRule tableRule, ItemsToken valuesToken, int parametersSize) {
        valuesToken.getItems().add(Symbol.QUESTION.getLiterals());
        this.getConditions().add(new Condition(new Column(tableRule.getGenerateKeyColumn(), tableRule.getLogicTable()), new SQLPlaceholderExpression(parametersSize)), shardingRule);
        this.generatedKey = new GeneratedKey(tableRule.getGenerateKeyColumn(), parametersSize, null);
    }

    private Optional<GeneratedKeyToken> findGeneratedKeyToken() {
        for (SQLToken each : this.getSqlTokens()) {
            if (!(each instanceof GeneratedKeyToken)) continue;
            return Optional.of((Object)((GeneratedKeyToken)each));
        }
        return Optional.absent();
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public List<Conditions> getMultipleConditions() {
        return this.multipleConditions;
    }

    public int getColumnsListLastPosition() {
        return this.columnsListLastPosition;
    }

    public int getGenerateKeyColumnIndex() {
        return this.generateKeyColumnIndex;
    }

    public int getAfterValuesPosition() {
        return this.afterValuesPosition;
    }

    public int getValuesListLastPosition() {
        return this.valuesListLastPosition;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public void setColumnsListLastPosition(int columnsListLastPosition) {
        this.columnsListLastPosition = columnsListLastPosition;
    }

    public void setGenerateKeyColumnIndex(int generateKeyColumnIndex) {
        this.generateKeyColumnIndex = generateKeyColumnIndex;
    }

    public void setAfterValuesPosition(int afterValuesPosition) {
        this.afterValuesPosition = afterValuesPosition;
    }

    public void setValuesListLastPosition(int valuesListLastPosition) {
        this.valuesListLastPosition = valuesListLastPosition;
    }

    public void setGeneratedKey(GeneratedKey generatedKey) {
        this.generatedKey = generatedKey;
    }

    @Override
    public String toString() {
        return "InsertStatement(columns=" + this.getColumns() + ", multipleConditions=" + this.getMultipleConditions() + ", columnsListLastPosition=" + this.getColumnsListLastPosition() + ", generateKeyColumnIndex=" + this.getGenerateKeyColumnIndex() + ", afterValuesPosition=" + this.getAfterValuesPosition() + ", valuesListLastPosition=" + this.getValuesListLastPosition() + ", generatedKey=" + this.getGeneratedKey() + ")";
    }
}

