/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dml.delete;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.sql.MySQLDeleteParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.sql.OracleDeleteParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql.PostgreSQLDeleteParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.sql.SQLServerDeleteParser;
import io.shardingjdbc.core.parsing.parser.sql.dml.delete.AbstractDeleteParser;
import io.shardingjdbc.core.rule.ShardingRule;

public final class DeleteParserFactory {
    public static AbstractDeleteParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDeleteParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDeleteParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDeleteParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDeleteParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private DeleteParserFactory() {
    }
}

