/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingjdbc.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithm;
import io.shardingjdbc.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public class MasterSlaveRuleConfiguration {
    private String name;
    private String masterDataSourceName;
    private Collection<String> slaveDataSourceNames = new LinkedList<String>();
    private MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType;
    private String loadBalanceAlgorithmClassName;

    public MasterSlaveRule build(Map<String, DataSource> dataSourceMap) {
        Preconditions.checkNotNull((Object)this.name, (Object)"name cannot be null.");
        Preconditions.checkNotNull((Object)this.masterDataSourceName, (Object)"masterDataSourceName cannot be null.");
        Preconditions.checkNotNull(this.slaveDataSourceNames, (Object)"slaveDataSourceNames cannot be null.");
        Preconditions.checkArgument((!this.slaveDataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"slaveDataSourceNames cannot be empty.");
        HashMap<String, DataSource> slaveDataSources = new HashMap<String, DataSource>(this.slaveDataSourceNames.size(), 1.0f);
        for (String each : this.slaveDataSourceNames) {
            slaveDataSources.put(each, dataSourceMap.get(each));
        }
        return new MasterSlaveRule(this.name, this.masterDataSourceName, dataSourceMap.get(this.masterDataSourceName), slaveDataSources, this.getLoadBalanceAlgorithm());
    }

    private MasterSlaveLoadBalanceAlgorithm getLoadBalanceAlgorithm() {
        MasterSlaveLoadBalanceAlgorithm result = null != this.loadBalanceAlgorithmType ? this.loadBalanceAlgorithmType.getAlgorithm() : (Strings.isNullOrEmpty((String)this.loadBalanceAlgorithmClassName) ? null : this.newInstance(this.loadBalanceAlgorithmClassName));
        return result;
    }

    public MasterSlaveLoadBalanceAlgorithm newInstance(String masterSlaveLoadBalanceAlgorithmClassName) {
        try {
            Class<?> result = Class.forName(masterSlaveLoadBalanceAlgorithmClassName);
            if (!MasterSlaveLoadBalanceAlgorithm.class.isAssignableFrom(result)) {
                throw new ShardingJdbcException("Class %s should be implement %s", masterSlaveLoadBalanceAlgorithmClassName, MasterSlaveLoadBalanceAlgorithm.class.getName());
            }
            return (MasterSlaveLoadBalanceAlgorithm)result.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingJdbcException("Class %s should have public privilege and no argument constructor", masterSlaveLoadBalanceAlgorithmClassName);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public MasterSlaveLoadBalanceAlgorithmType getLoadBalanceAlgorithmType() {
        return this.loadBalanceAlgorithmType;
    }

    public String getLoadBalanceAlgorithmClassName() {
        return this.loadBalanceAlgorithmClassName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMasterDataSourceName(String masterDataSourceName) {
        this.masterDataSourceName = masterDataSourceName;
    }

    public void setSlaveDataSourceNames(Collection<String> slaveDataSourceNames) {
        this.slaveDataSourceNames = slaveDataSourceNames;
    }

    public void setLoadBalanceAlgorithmType(MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType) {
        this.loadBalanceAlgorithmType = loadBalanceAlgorithmType;
    }

    public void setLoadBalanceAlgorithmClassName(String loadBalanceAlgorithmClassName) {
        this.loadBalanceAlgorithmClassName = loadBalanceAlgorithmClassName;
    }
}

