/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.util.KtorExperimentalAPI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteReadChannelJVMKt;
import kotlinx.coroutines.io.ByteWriteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a$\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001a=\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"expectHttpBody", "", "method", "Lio/ktor/http/HttpMethod;", "contentLength", "", "transferEncoding", "", "connectionOptions", "Lio/ktor/http/cio/ConnectionOptions;", "contentType", "request", "Lio/ktor/http/cio/Request;", "expectHttpUpgrade", "upgrade", "parseHttpBody", "", "headers", "Lio/ktor/http/cio/HttpHeadersMap;", "input", "Lkotlinx/coroutines/io/ByteReadChannel;", "out", "Lkotlinx/coroutines/io/ByteWriteChannel;", "(Lio/ktor/http/cio/HttpHeadersMap;Lkotlinx/coroutines/io/ByteReadChannel;Lkotlinx/coroutines/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lkotlinx/coroutines/io/ByteReadChannel;Lkotlinx/coroutines/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-http-cio"})
public final class HttpBodyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KtorExperimentalAPI
    public static final boolean expectHttpUpgrade(@NotNull HttpMethod method, @Nullable CharSequence upgrade, @Nullable ConnectionOptions connectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet())) return false;
        if (upgrade == null) return false;
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 == null) return false;
        if (!connectionOptions2.getUpgrade()) return false;
        return true;
    }

    @KtorExperimentalAPI
    public static final boolean expectHttpUpgrade(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return HttpBodyKt.expectHttpUpgrade(request.getMethod(), request.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")));
    }

    @KtorExperimentalAPI
    public static final boolean expectHttpBody(@NotNull HttpMethod method, long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @Nullable CharSequence contentType) {
        block4: {
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                if (Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getOptions())) {
                    return false;
                }
                if (transferEncoding != null) break block3;
                ConnectionOptions connectionOptions2 = connectionOptions;
                if (connectionOptions2 == null) break block4;
                if (!connectionOptions2.getClose()) break block4;
            }
            return true;
        }
        if (contentLength != -1L) {
            return contentLength > 0L;
        }
        return contentType != null;
    }

    @KtorExperimentalAPI
    public static final boolean expectHttpBody(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        CharSequence charSequence = request.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request.getMethod(), charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, request.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")), request.getHeaders().get("Content-Type"));
    }

    @KtorExperimentalAPI
    @Nullable
    public static final Object parseHttpBody(long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @NotNull ByteReadChannel input, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> $completion) {
        if (transferEncoding != null) {
            if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "chunked", 3, null)) {
                Object object = ChunkedTransferEncodingKt.decodeChunked(input, out, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (!CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "identity", 3, null)) {
                out.close((Throwable)new IllegalStateException("Unsupported transfer-encoding " + transferEncoding));
            }
        }
        if (contentLength != -1L) {
            Object object = ByteReadChannelJVMKt.copyTo((ByteReadChannel)input, (ByteWriteChannel)out, (long)contentLength, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 != null) {
            if (connectionOptions2.getClose()) {
                Object object = ByteReadChannelJVMKt.copyTo((ByteReadChannel)input, (ByteWriteChannel)out, (long)Long.MAX_VALUE, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        IllegalStateException cause = new IllegalStateException("Failed to parse request body: request body length should be specified,\nchunked transfer encoding should be used or\nkeep-alive should be disabled (connection: close)");
        out.close((Throwable)cause);
        return Unit.INSTANCE;
    }

    @KtorExperimentalAPI
    @Nullable
    public static final Object parseHttpBody(@NotNull HttpHeadersMap headers, @NotNull ByteReadChannel input, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> $completion) {
        Object object = headers.get("Content-Length");
        Object object2 = HttpBodyKt.parseHttpBody(object != null && (object = Boxing.boxLong((long)CharsKt.parseDecLong((CharSequence)object))) != null ? (Long)object : -1L, headers.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(headers.get("Connection")), input, out, $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }
}

