/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbResultSetCache_h
extends DmdbResultSetCache {
    public int offset = 0;
    short nflds = (short)-1;
    public byte[] rowbuf = null;
    private DmdbColumn[] cols = null;

    public DmdbResultSetCache_h(DmdbStatement_bs stmt, DmdbColumn[] colsInfo) {
        super(stmt, colsInfo);
        this.cols = colsInfo;
    }

    void env_stmt_init_curbuf() {
        this.setRownum(0);
        this.offset = 0;
        this.curpos = 0;
    }

    @Override
    public void fillBuffer(byte[] buffer, int len, int rows) {
        this.env_stmt_init_curbuf();
        this.rowbuf = buffer;
        this.setRownum(rows);
        this.realLen = len;
        this.nflds = (short)this.cols.length;
    }

    @Override
    public void fillBuffer2(byte[] buffer, int off, int len, int rows) {
        this.env_stmt_init_curbuf();
        if (this.rowbuf == null) {
            this.rowbuf = new byte[len];
        } else if (this.rowbuf.length < len) {
            this.rowbuf = new byte[len];
        }
        System.arraycopy(buffer, off, this.rowbuf, 0, len);
        this.setRownum(rows);
        this.realLen = len;
        this.nflds = (short)this.cols.length;
    }

    @Override
    public void addBuffer(byte[] buffer, int len, int rows) {
        byte[] tmp = new byte[this.realLen + len];
        System.arraycopy(this.rowbuf, 0, tmp, 0, this.realLen);
        System.arraycopy(buffer, 0, tmp, this.realLen, len);
        this.rowbuf = tmp;
        this.setRownum(this.getRownum() + rows);
        this.realLen += len;
    }

    @Override
    public byte[] getBytes(short columnNo) throws SQLException {
        return this.rec4_get_nth_fld_data(this.rowbuf, this.offset, columnNo);
    }

    @Override
    public boolean getBytes(short columnNo, byte[] returnBuffer) throws SQLException {
        return this.rec4_get_nth_fld_data(this.rowbuf, this.offset, columnNo, returnBuffer);
    }

    @Override
    public boolean next() {
        if (this.curpos >= this.getRownum()) {
            return false;
        }
        int rec_len = this.rec4_get_len(this.rowbuf, this.offset);
        this.offset += rec_len;
        if (this.offset >= this.realLen) {
            ++this.curpos;
            return true;
        }
        ++this.curpos;
        return true;
    }

    @Override
    public boolean previous() {
        if (this.curpos <= 0) {
            return false;
        }
        this.offset = 0;
        int i = 0;
        while (i < this.curpos - 1) {
            this.offset += this.rec4_get_len(this.rowbuf, this.offset);
            i = (short)(i + 1);
        }
        --this.curpos;
        return true;
    }

    @Override
    public boolean absolute(int position) {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.getRownum()) {
            position = this.getRownum() - 1;
        }
        this.offset = 0;
        int i = 0;
        while (i < position) {
            this.offset += this.rec4_get_len(this.rowbuf, this.offset);
            i = (short)(i + 1);
        }
        this.curpos = position;
        return true;
    }

    short rec4_read_2byte_len(byte[] addr, int off) {
        return (short)(((short)addr[off] << 8) + (short)(0xFF & addr[off + 1]));
    }

    short rec4_get_var_alen(byte[] addr, int off, byte[] nth_ctl_len) {
        if ((addr[off] & 0x80) != 0) {
            nth_ctl_len[0] = 1;
            return (short)(addr[off] & 0x7F);
        }
        nth_ctl_len[0] = 2;
        return this.rec4_read_2byte_len(addr, off);
    }

    int rec4_get_nth_fld_offset(byte[] rec, int recOff, short nthFld) {
        int head = recOff + 2 + 8;
        short recLen = Convertion.getShort(rec, recOff);
        if (recLen != 0) {
            return Convertion.getUShort(rec, head + nthFld * 2) + recOff;
        }
        int fld_len1 = 0;
        long fld_len2 = 0L;
        int offSetRet = head += this.nflds * 2;
        int i = 0;
        while (i < nthFld) {
            fld_len1 = Convertion.getUShort(rec, offSetRet);
            offSetRet += 2;
            if (-1 == fld_len1) {
                fld_len2 = Convertion.getUInt(rec, offSetRet);
                offSetRet += 4;
                offSetRet = (int)((long)offSetRet + fld_len2);
            } else {
                offSetRet += fld_len1;
            }
            ++i;
        }
        return offSetRet;
    }

    public byte[] rec4_get_nth_fld_data(byte[] rec, int recOff, short nthFld) throws SQLException {
        if (rec == null) {
            return null;
        }
        int nthFldOff = this.rec4_get_nth_fld_offset(rec, recOff, nthFld);
        int fld_len1 = Convertion.getUShort(rec, nthFldOff);
        if (65534 == fld_len1) {
            return null;
        }
        int dataOff = nthFldOff + 2;
        if (65535 != fld_len1) {
            byte[] returnBuffer = new byte[fld_len1];
            System.arraycopy(rec, dataOff, returnBuffer, 0, fld_len1);
            return returnBuffer;
        }
        int fld_len2 = Convertion.getInt(rec, dataOff);
        if (fld_len2 <= 0) {
            DBError.throwSQLException(20004);
        }
        byte[] returnBuffer = new byte[fld_len2];
        System.arraycopy(rec, dataOff += 4, returnBuffer, 0, fld_len2);
        return returnBuffer;
    }

    public boolean rec4_get_nth_fld_data(byte[] rec, int recOff, short nthFld, byte[] returnBuffer) throws SQLException {
        if (rec == null) {
            return true;
        }
        int nthFldOff = this.rec4_get_nth_fld_offset(rec, recOff, nthFld);
        int fld_len1 = Convertion.getUShort(rec, nthFldOff);
        if (65534 == fld_len1) {
            return true;
        }
        int dataOff = nthFldOff + 2;
        if (65535 != fld_len1) {
            if (returnBuffer == null || returnBuffer.length != fld_len1) {
                returnBuffer = new byte[fld_len1];
            }
            System.arraycopy(rec, dataOff, returnBuffer, 0, fld_len1);
            return false;
        }
        int fld_len2 = Convertion.getInt(rec, dataOff);
        if (fld_len2 <= 0) {
            DBError.throwSQLException(20004);
        }
        dataOff += 4;
        if (returnBuffer == null || returnBuffer.length != fld_len2) {
            returnBuffer = new byte[fld_len2];
        }
        System.arraycopy(rec, dataOff, returnBuffer, 0, fld_len2);
        return false;
    }

    int rec4_get_len(byte[] rec, int off) {
        return Convertion.getUShort(rec, off);
    }

    @Override
    long rec_get_rowid() {
        if (this.rowbuf == null) {
            try {
                DBError.throwSQLException(6021);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return 0L;
            }
        }
        return Convertion.getLong(this.rowbuf, this.offset + 2);
    }

    public void move_to_next() {
        while (this.rec4_is_deleted_rec()) {
            int rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
            if (this.offset < this.realLen) continue;
            return;
        }
    }

    void rec4_set_deleted_mark() {
        int n = this.offset + 1;
        this.rowbuf[n] = (byte)(this.rowbuf[n] | 0x80);
    }

    boolean rec4_is_deleted_rec() {
        return (this.rowbuf[this.offset + 1] & 0x80) != 0;
    }

    public Vector<Long> getDeletedRowid() {
        Vector<Long> tmp = new Vector<Long>();
        this.offset = 0;
        int row = 0;
        while (row < this.getRownum()) {
            if (this.rec4_is_deleted_rec()) {
                long rowid = Convertion.getLong(this.rowbuf, this.offset + 2);
                tmp.add(new Long(rowid));
            }
            int rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
            ++row;
        }
        return tmp;
    }

    @Override
    public void setCols(DmdbColumn[] colInfo) {
        this.cols = colInfo;
    }

    @Override
    public final Object clone() {
        DmdbResultSetCache_h rsCache = null;
        rsCache = (DmdbResultSetCache_h)super.clone();
        rsCache.cols = null;
        rsCache.setStatement(null);
        rsCache.offset = 0;
        rsCache.curpos = 0;
        if (this.rowbuf != null) {
            rsCache.rowbuf = (byte[])this.rowbuf.clone();
        }
        return rsCache;
    }
}

