/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DmdbNumeric {
    private static final int XDEC_TEMPBUF_SIZE = 21;
    private static final int XDEC_POSITIVE = 193;
    private static final int XDEC_NEGTIVE = 62;
    private static final int XDEC_NEGTIVE_NUM = 101;
    private static final int XDEC_SIGN_POSITIVE = 1;
    private static final int XDEC_SIGN_NEGTIVE = 0;
    private int n = 0;
    private int m = 0;
    private int m_sign = 1;
    private int m_exp = 0;
    private String m_strInt = null;
    private String m_strDec = null;
    private int m_max_len = 38;

    private String checkStr(String strOrg, int prec, int scale) throws SQLException {
        String str = null;
        try {
            BigDecimal bgd = new BigDecimal(strOrg);
            str = bgd.toString();
            if (prec != 0 || scale != 0) {
                BigDecimal bgd2 = bgd.setScale(scale, 4);
                str = bgd2.toString();
                this.m_max_len = prec;
            }
        }
        catch (NumberFormatException ex) {
            DBError.throwSQLException(6007);
        }
        return str;
    }

    private String setSign(String strOrg) {
        this.m_sign = 1;
        if (strOrg.startsWith("-")) {
            this.m_sign = 0;
            return strOrg.substring(1);
        }
        if (strOrg.startsWith("+")) {
            this.m_sign = 1;
            return strOrg.substring(1);
        }
        return strOrg;
    }

    private String rmvUnnecessaryZeros(String strOrg) {
        int zeroStartIndex = 0;
        while (zeroStartIndex < strOrg.length() && '0' == strOrg.charAt(zeroStartIndex)) {
            ++zeroStartIndex;
        }
        int pIndex = strOrg.substring(zeroStartIndex).indexOf(46);
        int zeroEndIndex = strOrg.length() - 1;
        while (-1 != pIndex && '0' == strOrg.charAt(zeroEndIndex) && zeroEndIndex >= 0) {
            --zeroEndIndex;
        }
        if (-1 != pIndex) {
            return strOrg.substring(zeroStartIndex, zeroEndIndex + 1);
        }
        return strOrg.substring(zeroStartIndex);
    }

    private void setDecInt(String strRet) {
        int pIndex = strRet.indexOf(46);
        if (pIndex == 0) {
            this.m_strInt = null;
            this.m_strDec = 1 == strRet.length() ? null : strRet.substring(1);
        } else if (-1 == pIndex || strRet.length() - 1 == pIndex) {
            this.m_strDec = null;
            this.m_strInt = -1 == pIndex ? strRet : strRet.substring(0, strRet.length() - 1);
        } else {
            this.m_strInt = strRet.substring(0, pIndex);
            this.m_strDec = strRet.substring(pIndex + 1);
        }
    }

    private boolean checkZero(String strRet) {
        BigDecimal big = new BigDecimal(strRet);
        BigDecimal zero = new BigDecimal(0);
        return big.compareTo(zero) == 0;
    }

    private int cntZeroEnd(String strInt) {
        int end = strInt.length() - 1;
        while (end >= 0 && '0' == strInt.charAt(end)) {
            --end;
        }
        return strInt.length() - 1 - end;
    }

    private int cntZeroStart(String strDec) {
        int start = 0;
        while (start < strDec.length() && '0' == strDec.charAt(start)) {
            ++start;
        }
        return start;
    }

    private byte[] processStrInt() {
        if (this.m_strInt == null) {
            return null;
        }
        int strLen = this.m_strInt.length();
        int sub = 0;
        int start = 0;
        int btCnt = strLen / 2;
        if (strLen % 2 != 0) {
            ++btCnt;
        }
        byte[] temp = new byte[btCnt];
        boolean bOdd = false;
        if (strLen % 2 != 0) {
            sub = Integer.parseInt(this.m_strInt.substring(0, 1), 10);
            temp[start] = this.m_sign == 1 ? (byte)(sub + 1) : (byte)(101 - sub);
            ++start;
            bOdd = true;
        }
        while (start < btCnt) {
            sub = bOdd ? Integer.parseInt(this.m_strInt.substring(start * 2 - 1, start * 2 + 1 <= strLen ? start * 2 + 1 : strLen), 10) : Integer.parseInt(this.m_strInt.substring(start * 2, start * 2 + 2 < strLen ? start * 2 + 2 : strLen), 10);
            temp[start] = this.m_sign == 1 ? (byte)(sub + 1) : (byte)(101 - sub);
            ++start;
        }
        return temp;
    }

    private byte[] processStrDec() {
        if (this.m_strDec == null) {
            return null;
        }
        int strLen = this.m_strDec.length();
        int sub = 0;
        if (strLen % 2 != 0) {
            this.m_strDec = String.valueOf(this.m_strDec) + "0";
            strLen = this.m_strDec.length();
        }
        int btCnt = strLen / 2;
        byte[] temp = new byte[btCnt];
        int start = 0;
        while (start < btCnt) {
            sub = Integer.parseInt(this.m_strDec.substring(start * 2, start * 2 + 2 > strLen ? strLen : start * 2 + 2), 10);
            temp[start] = this.m_sign == 1 ? (byte)(sub + 1) : (byte)(101 - sub);
            ++start;
        }
        return temp;
    }

    private byte fixFlag() throws SQLException {
        byte bt = 0;
        bt = this.m_sign == 1 ? (byte)(193 + this.m_exp / 2) : (byte)(62 - this.m_exp / 2);
        return bt;
    }

    private byte[] fixDec(byte flag, byte[] btBefore, byte[] btAfter) throws SQLException {
        int len = 0;
        byte[] temp = new byte[21];
        temp[0] = flag;
        ++len;
        if (btBefore != null) {
            byte[] btBefTmp = null;
            if (btBefore.length > 21 - len) {
                btBefTmp = new byte[Math.abs(21 - len)];
                System.arraycopy(btBefore, 0, btBefTmp, 0, btBefTmp.length);
            } else {
                btBefTmp = btBefore;
            }
            System.arraycopy(btBefTmp, 0, temp, len, btBefTmp.length);
            len += btBefTmp.length;
        }
        if (btAfter != null) {
            byte[] btAftTmp = null;
            if (btAfter.length > 21 - len) {
                btAftTmp = new byte[Math.abs(21 - len)];
                System.arraycopy(btAfter, 0, btAftTmp, 0, btAftTmp.length);
            } else {
                btAftTmp = btAfter;
            }
            System.arraycopy(btAftTmp, 0, temp, len, btAftTmp.length);
            len += btAftTmp.length;
        }
        if (this.m_sign == 0 && len < 20) {
            temp[len++] = 102;
        }
        if (len < 20) {
            temp[len] = 0;
        }
        byte[] Ret = new byte[len];
        System.arraycopy(temp, 0, Ret, 0, len);
        return Ret;
    }

    private byte[] fixZero() {
        byte[] ret = new byte[]{-128};
        return ret;
    }

    private String setExp(String strOrg) {
        int eIndex = strOrg.indexOf(101);
        if (-1 == eIndex) {
            eIndex = strOrg.indexOf(69);
        }
        if (-1 == eIndex) {
            this.m_exp = 0;
            return strOrg;
        }
        String strExp = strOrg.substring(eIndex + 1);
        int n = strExp.indexOf(43);
        if (-1 != n) {
            strExp = strExp.substring(n + 1);
        }
        this.m_exp = Integer.parseInt(strExp, 10);
        return strOrg.substring(0, eIndex);
    }

    private void checkOverFlow() throws SQLException {
        if (this.m_exp > 123 || this.m_exp < -128) {
            DBError.throwSQLException(-2502);
        }
    }

    private void processExp() {
        if (this.m_exp % 2 == 0) {
            return;
        }
        String strDec = this.m_strDec;
        String strInt = this.m_strInt;
        if (strInt == null && strDec != null) {
            if (strDec.startsWith("0")) {
                this.m_strDec = this.m_strDec.substring(1);
            } else {
                this.m_strInt = this.m_strDec.substring(0, 1);
                this.m_strDec = this.m_strDec.substring(1);
            }
        } else if (strInt != null && strDec == null) {
            this.m_strInt = String.valueOf(this.m_strInt) + "0";
        } else {
            this.m_strInt = String.valueOf(this.m_strInt) + this.m_strDec.substring(0, 1);
            this.m_strDec = this.m_strDec.substring(1);
        }
        --this.m_exp;
        if (this.m_strInt != null) {
            this.m_strInt = this.rmvUnnecessaryZeros(this.m_strInt);
        }
        if (this.m_strDec != null) {
            this.m_strDec = this.rmvUnnecessaryZeros("." + this.m_strDec).substring(1);
        }
    }

    private void setMN() {
        String strInt = this.m_strInt;
        String strDec = this.m_strDec;
        if (strInt != null && strDec == null) {
            this.n = this.m_strInt.length();
            this.m = this.cntZeroEnd(this.m_strInt);
            if (this.m % 2 != 0) {
                --this.m;
            }
            this.m_exp += this.m;
            this.m_strInt = this.m_strInt.substring(0, this.n - this.m);
            this.n = this.m_strInt.length();
            if (this.n % 2 != 0) {
                ++this.n;
            }
            this.m_exp += this.n - 2;
        } else if (strInt == null && strDec != null) {
            this.n = strDec.length();
            this.m = this.cntZeroStart(strDec);
            if (this.m % 2 != 0) {
                --this.m;
            }
            this.m_exp -= this.m;
            if (this.n - this.m < 2) {
                strDec = String.valueOf(strDec) + "0";
            }
            this.m_strInt = strDec.substring(this.m, this.m + 2);
            this.m_strDec = strDec.substring(this.m + 2);
            this.m_exp -= 2;
            if (this.m_strInt.startsWith("0")) {
                this.m_strInt = this.m_strInt.substring(1);
            }
        } else {
            this.n = strInt.length();
            if (this.n % 2 != 0) {
                ++this.n;
            }
            this.m_exp += this.n - 2;
        }
    }

    private void checkMaxLen() throws SQLException {
        int iLen;
        int n = iLen = this.m_strInt == null ? 0 : this.m_strInt.length();
        if (iLen > this.m_max_len) {
            DBError.throwSQLException(-2502);
        }
    }

    public byte[] StrToDec(String str, int prec, int scal) throws SQLException {
        str = str.trim();
        if (this.checkZero(str = this.checkStr(str, prec, scal))) {
            return this.fixZero();
        }
        str = this.setExp(str);
        str = this.setSign(str);
        String strRet = this.rmvUnnecessaryZeros(str);
        this.setDecInt(strRet);
        this.processExp();
        this.setMN();
        this.checkMaxLen();
        this.checkOverFlow();
        return this.fixDec(this.fixFlag(), this.processStrInt(), this.processStrDec());
    }

    public String decToString(byte[] arr) throws SQLException {
        int length = arr.length;
        boolean sign = true;
        short dec_head = 0;
        byte exp = 0;
        int zeros = 0;
        int bits = 0;
        boolean bigger = true;
        if (arr.length == 0 || arr.length > 21) {
            DBError.throwSQLException(20004);
        }
        if (arr[0] == -128 || arr.length == 1) {
            return "0";
        }
        StringBuffer str = new StringBuffer();
        StringBuffer strtmp = new StringBuffer();
        dec_head = arr[0] < 0 ? (short)(arr[0] + 256) : arr[0];
        sign = (arr[0] & 0x80) == 128;
        exp = sign ? (byte)(dec_head - 193) : (byte)(62 - dec_head);
        while (length > 0) {
            if (arr[length - 1] != 0) break;
            --length;
        }
        int i = 1;
        while (i < length) {
            if (sign) {
                if (arr[i] - 1 < 10 && i != 1) {
                    strtmp.append("0");
                }
                strtmp.append(arr[i] - 1);
            } else if (arr[i] != 102) {
                if (101 - arr[i] < 10 && i != 1) {
                    strtmp.append("0");
                }
                strtmp.append(101 - arr[i]);
            }
            ++i;
        }
        if (sign && arr[1] - 1 < 10) {
            bigger = false;
        } else if (!sign && 101 - arr[1] < 10) {
            bigger = false;
        }
        if (exp > 0) {
            bits = bigger ? exp * 2 + 2 : exp * 2 + 1;
            if (bits > strtmp.length()) {
                zeros = bits - strtmp.length();
                i = 0;
                while (i < zeros) {
                    strtmp.append("0");
                    ++i;
                }
            } else if (bits < strtmp.length()) {
                strtmp.insert(bits, '.');
            }
        } else if (exp == 0) {
            if (strtmp.length() > 2) {
                if (bigger) {
                    strtmp.insert(2, '.');
                } else {
                    strtmp.insert(1, '.');
                }
            }
        } else {
            exp = (byte)(exp * -1);
            zeros = bigger ? exp * 2 - 2 : exp * 2 - 1;
            strtmp.insert(0, "0.");
            i = 0;
            while (i < zeros) {
                strtmp.insert(2, "0");
                ++i;
            }
            strtmp = new StringBuffer(this.rmvUnnecessaryZeros(strtmp.substring(0, strtmp.length())));
            strtmp.insert(0, "0");
        }
        boolean dotFind = false;
        if (strtmp.indexOf(".") > 0) {
            while (strtmp.charAt(strtmp.length() - 1) == '0' || strtmp.charAt(strtmp.length() - 1) == '.') {
                if (strtmp.charAt(strtmp.length() - 1) == '.') {
                    dotFind = true;
                }
                strtmp.deleteCharAt(strtmp.length() - 1);
                if (dotFind) break;
            }
        }
        if (!sign) {
            str.append("-");
        }
        str.append(strtmp.toString());
        return str.toString();
    }
}

