/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.AbstractProxy;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbDatabaseMetaData_bs;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.stat.ConnectionStat;
import dm.jdbc.stat.StatService;
import dm.sql.ARRAY;
import dm.sql.ArrayDescriptor;
import dm.sql.STRUCT;
import dm.sql.StructDescriptor;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbConnection
extends AbstractProxy<DmdbConnection_bs>
implements Connection {
    DmdbDatabaseMetaData m_dbMetaData = null;
    private ConnectionStat connStat;
    private long constructNano;
    protected DmdbConnection_bs rConn = null;
    private static AtomicLong index = new AtomicLong(0L);

    public DmdbConnection(DmdbConnection_bs conn) {
        super(conn);
        this.rConn = conn;
        this.ID = index.incrementAndGet();
        this.createChain().Connection_create(this);
    }

    public DmdbConnection_bs getRealConn() {
        return this.rConn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createChain().Connection_createStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.createChain().Connection_prepareCall(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.createChain().Connection_nativeSQL(this, sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.createChain().Connection_setAutoCommit(this, autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.createChain().Connection_getAutoCommit(this);
    }

    @Override
    public void commit() throws SQLException {
        this.createChain().Connection_commit(this);
    }

    @Override
    public void rollback() throws SQLException {
        this.createChain().Connection_rollback(this);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().Connection_close(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().Connection_isClosed(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.createChain().Connection_getMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.createChain().Connection_setReadOnly(this, readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.createChain().Connection_isReadOnly(this);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.createChain().Connection_setCatalog(this, catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.createChain().Connection_getCatalog(this);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.createChain().Connection_setTransactionIsolation(this, level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.createChain().Connection_getTransactionIsolation(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().Connection_getWarnings(this);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().Connection_clearWarnings(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().Connection_createStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().Connection_prepareCall(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.createChain().Connection_getTypeMap(this);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.createChain().Connection_setTypeMap(this, map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.createChain().Connection_setHoldability(this, holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.createChain().Connection_getHoldability(this);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.createChain().Connection_setSavepoint(this);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.createChain().Connection_setSavepoint(this, name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.createChain().Connection_rollback(this, savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.createChain().Connection_releaseSavepoint(this, savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().Connection_createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().Connection_prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.createChain().Connection_prepareStatement(this, sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.createChain().Connection_createClob(this);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.createChain().Connection_createBlob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.createChain().Connection_createNClob(this);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.createChain().Connection_createSQLXML(this);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.createChain().Connection_isValid(this, timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.createChain().Connection_setClientInfo(this, name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.createChain().Connection_setClientInfo(this, properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.createChain().Connection_getClientInfo(this, name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.createChain().Connection_getClientInfo(this);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.createChain().Connection_createArrayOf(this, typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.createChain().Connection_createStruct(this, typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.createChain().Connection_setSchema(this, schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.createChain().Connection_getSchema(this);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.createChain().Connection_abort(this, executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.createChain().Connection_setNetworkTimeout(this, executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.createChain().Connection_getNetworkTimeout(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public boolean isLogicalConnection() {
        return this.rConn.isLogicalConnection();
    }

    public synchronized Statement do_createStatement() throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(), this);
        return stmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.rConn.prepareStatement(sql), this);
        return pstmt;
    }

    public synchronized CallableStatement do_prepareCall(String sql) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql), this);
        return cstmt;
    }

    public String do_nativeSQL(String sql) throws SQLException {
        return this.rConn.nativeSQL(sql);
    }

    public synchronized void do_setAutoCommit(boolean autoCommit) throws SQLException {
        this.rConn.setAutoCommit(autoCommit);
    }

    public boolean do_getAutoCommit() throws SQLException {
        return this.rConn.getAutoCommit();
    }

    public synchronized void do_commit() throws SQLException {
        this.rConn.commit();
    }

    public synchronized void do_rollback() throws SQLException {
        this.rConn.rollback();
    }

    public synchronized void do_close() throws SQLException {
        this.rConn.close();
    }

    public synchronized void closeForAgent() throws SQLException {
        this.rConn.closeForAgent();
    }

    public synchronized void logicalClose() throws SQLException {
        this.rConn.logicalClose();
    }

    public boolean do_isClosed() throws SQLException {
        return this.rConn.isClosed();
    }

    public synchronized DatabaseMetaData do_getMetaData() throws SQLException {
        if (this.m_dbMetaData == null) {
            DmdbDatabaseMetaData_bs bs = (DmdbDatabaseMetaData_bs)this.rConn.getMetaData();
            if (bs == null) {
                return null;
            }
            this.m_dbMetaData = new DmdbDatabaseMetaData(bs);
        }
        return this.m_dbMetaData;
    }

    public void do_setReadOnly(boolean readOnly) throws SQLException {
        this.rConn.setReadOnly(readOnly);
    }

    public boolean do_isReadOnly() throws SQLException {
        return this.rConn.isReadOnly();
    }

    public void do_setCatalog(String catalog) throws SQLException {
        this.rConn.setCatalog(catalog);
    }

    public String do_getCatalog() throws SQLException {
        return this.rConn.getCatalog();
    }

    public final String getUserName() throws SQLException {
        return this.rConn.getCurrentUserName();
    }

    public final boolean isCompress() {
        return this.rConn.isCompress();
    }

    public synchronized void do_setTransactionIsolation(int level) throws SQLException {
        this.rConn.setTransactionIsolation(level);
    }

    public int do_getTransactionIsolation() throws SQLException {
        return this.rConn.getTransactionIsolation();
    }

    public SQLWarning do_getWarnings() throws SQLException {
        return this.rConn.getWarnings();
    }

    public void do_clearWarnings() throws SQLException {
        this.rConn.clearWarnings();
    }

    public synchronized Statement do_createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(resultSetType, resultSetConcurrency), this);
        return stmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
        return pstmt;
    }

    public synchronized CallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        return cstmt;
    }

    public Map<String, Class<?>> do_getTypeMap() throws SQLException {
        return this.rConn.getTypeMap();
    }

    public synchronized void do_setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.rConn.setTypeMap(map);
    }

    public synchronized void do_setHoldability(int holdability) throws SQLException {
        this.rConn.setHoldability(holdability);
    }

    public int do_getHoldability() throws SQLException {
        return this.rConn.getHoldability();
    }

    public synchronized Savepoint do_setSavepoint() throws SQLException {
        return this.rConn.setSavepoint();
    }

    public synchronized Savepoint do_setSavepoint(String name) throws SQLException {
        return this.rConn.setSavepoint(name);
    }

    public synchronized void do_rollback(Savepoint savepoint) throws SQLException {
        this.rConn.rollback(savepoint);
    }

    public synchronized void do_releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.rConn.releaseSavepoint(savepoint);
    }

    public synchronized Statement do_createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return stmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.rConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return pstmt;
    }

    public synchronized CallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return cstmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.rConn.prepareStatement(sql, autoGeneratedKeys), this);
        return pstmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.rConn.prepareStatement(sql, columnIndexes), this);
        return pstmt;
    }

    public synchronized PreparedStatement do_prepareStatement(String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.rConn.prepareStatement(sql, columnNames), this);
        return pstmt;
    }

    public String getExplainInfo(String str) throws SQLException {
        return this.rConn.getExplainInfo(str);
    }

    public String getSessionTrace(String str) throws SQLException {
        return this.rConn.getSessionTrace(str);
    }

    public int getGlobalServerSeries() {
        return this.rConn.getGlobalServerSeries();
    }

    public String getLastLoginIP() {
        return this.rConn.getLastLoginIP();
    }

    public String getLastLoginTime() {
        return this.rConn.getLastLoginTime();
    }

    public int getLoginWarningID() {
        return this.rConn.getLoginWarningID();
    }

    public int getGraceTimeRemainder() {
        return this.rConn.getGraceTimeRemainder();
    }

    public int getFailedAttempt() {
        return this.rConn.getFailedAttempt();
    }

    public Boolean getNetworkEncypted() {
        return this.rConn.getEncryptMsg() == 1;
    }

    public int getNetworkPacketSize() {
        return this.rConn.getNetworkPacketSize();
    }

    public int getConnectTimeout() {
        return this.rConn.getConnectTimeout();
    }

    public int getEncryptMsg() {
        return this.rConn.getEncryptMsg();
    }

    public String getHostName() {
        return this.rConn.getHost();
    }

    public String getHostPort() {
        return String.valueOf(this.rConn.getPort());
    }

    public Boolean getEscape() {
        return this.rConn.isEscapeProcess();
    }

    public void setEscape(Boolean escapeFlag) {
        this.rConn.setEscapeProcess(escapeFlag);
    }

    public void setDbmdChkPrivileges(boolean chk) {
        this.rConn.setDbmdChkPrv(chk);
    }

    public boolean getDbmdChkPrivileges() {
        return this.rConn.isDbmdChkPrv();
    }

    public int getLanguage() {
        return this.rConn.getLanguage();
    }

    public Clob do_createClob() throws SQLException {
        return new DmdbClob(this);
    }

    public Blob do_createBlob() throws SQLException {
        return new DmdbBlob(this);
    }

    public NClob do_createNClob() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public SQLXML do_createSQLXML() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public boolean do_isValid(int timeout) throws SQLException {
        try {
            this.rConn.checkClosed();
            Statement stmt = this.rConn.createStatement();
            stmt.execute("select 1 from dual");
            stmt.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void do_setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name == null || value == null) {
            String reason = "Invalid Parameters\uff0cProperty name or value is null";
            throw new SQLClientInfoException(reason, null);
        }
        this.rConn.setClientInfo(name, value);
    }

    public void do_setClientInfo(Properties properties) throws SQLClientInfoException {
        this.rConn.setClientInfo(properties);
    }

    public String do_getClientInfo(String name) throws SQLException {
        if (name == null) {
            DBError.throwSQLException("Invalid Property Name which is null");
        }
        return this.rConn.getClientInfo(name);
    }

    public Properties do_getClientInfo() throws SQLException {
        return this.rConn.getClientInfo();
    }

    public Array do_createArrayOf(String typeName, Object[] elements) throws SQLException {
        ArrayDescriptor arr_desc = ArrayDescriptor.createDescriptor(typeName, this);
        return new ARRAY(arr_desc, this, elements);
    }

    public Struct do_createStruct(String typeName, Object[] attributes) throws SQLException {
        StructDescriptor struct_desc = StructDescriptor.createDescriptor(typeName, this);
        return new STRUCT(struct_desc, this, attributes);
    }

    public void reset() throws SQLException {
        this.rConn.reset();
    }

    public boolean getRwSeparate() {
        return this.rConn.getRwSeparate();
    }

    public double getRwPercent() {
        return this.rConn.getRwPercent();
    }

    public void do_setSchema(String schema) throws SQLException {
        try (Statement stmt = null;){
            if (schema != null && schema.length() > 0) {
                stmt = this.rConn.createStatement();
                stmt.execute("set schema " + schema);
                this.rConn.setSchema(schema);
            }
        }
    }

    public String do_getSchema() throws SQLException {
        return this.rConn.getSchema();
    }

    public void do_abort(Executor executor) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public int do_getNetworkTimeout() throws SQLException {
        return this.rConn.getSocketTimeout();
    }

    public ConnectionStat getConnStat() {
        if (this.connStat == null) {
            this.connStat = StatService.jdbcStat.createConnStat(this.getRealConn());
        }
        return this.connStat;
    }

    public void setConstructNano() {
        this.constructNano = System.nanoTime();
    }

    public long getConstructNano() {
        return this.constructNano;
    }
}

