/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DataOfFetch;
import dm.jdbc.dbaccess.DbAccessPure;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.DmdbRwAutoDistribute;
import dm.jdbc.dbaccess.DmdbRwUserDistribute;
import dm.jdbc.dbaccess.DmdbSingleDistribute;
import dm.jdbc.dbaccess.Request_Response;
import dm.jdbc.desc.DmdbExecOpt;
import dm.jdbc.desc.PreExeced;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbLobLocator;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.util.StringUtil;
import dm.jdbc.xa.DmdbXAResource;
import dm.jdbc.xa.DmdbXid;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class DmdbCSI {
    private static void startupServer(DmMsgSend msg, DmdbConnection_bs conn, int rwDestType) throws IOException, SQLException {
        Request_Response.req_startup(msg, conn, rwDestType);
        DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null, rwDestType);
        Request_Response.resp_startup(recvMsg, conn, rwDestType);
        if (conn.getEncryptMsg() == 2) {
            conn.getDbAccess().tryEnableSSL(false, rwDestType);
        } else if (conn.getEncryptMsg() == 1) {
            conn.getDbAccess().tryEnableSSL(true, rwDestType);
        } else {
            return;
        }
    }

    private static final void login(DmMsgSend msg, DmdbConnection_bs conn, int rwDestType) throws SQLException, IOException {
        Request_Response.req_login(msg, conn, rwDestType);
        DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null, rwDestType);
        if (rwDestType == 0) {
            Request_Response.resp_checkErr(recvMsg, conn);
        } else {
            Request_Response.resp_login(recvMsg, conn);
        }
    }

    public static final void connToPrimary(DmdbConnection_bs conn) throws SQLException, IOException {
        DmdbCSI.connToServerInner(conn, 1);
    }

    public static final boolean connToStandby(DmdbConnection_bs conn) {
        try {
            if (StringUtil.isNotEmpty(conn.getStandbyHost())) {
                conn.getDbAccess().setAccessStandby(new DbAccessPure(conn, conn.getStandbyHost(), conn.getStandbyPort()));
                DmdbCSI.connToServerInner(conn, 0);
                return true;
            }
        }
        catch (Exception e) {
            conn.getDbAccess().removeStandby();
        }
        return false;
    }

    public static final void connToServerInner(DmdbConnection_bs conn, int rwDestType) throws IOException, SQLException {
        String user = conn.getUser();
        if (user.length() > 2 && user.startsWith("///")) {
            DmdbCSI.KerberosProtocal(conn, user.substring(3), rwDestType);
        }
        DmMsgSend msg = conn.getMsg();
        try {
            DmdbCSI.startupServer(msg, conn, rwDestType);
            DmdbCSI.login(msg, conn, rwDestType);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
    }

    private static void KerberosProtocal(DmdbConnection_bs conn, String kerberosUser, int rwDestType) throws SQLException {
        AuthInfo clientAuthInfo = conn.getDbAccess().initAuthInfo(kerberosUser, conn.getKerberosLoginConfPath(), 2, rwDestType);
        if (clientAuthInfo == null) {
            DBError.throwSQLException(6001);
        }
        String user = "///" + clientAuthInfo.getUserName();
        conn.setUser(user);
    }

    public static final int allocStmtHandle(DmdbStatement_bs stmt) throws SQLException {
        int handle = 0;
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend msg = conn.getMsg();
        DmMsgRecv recvMsg = null;
        try {
            Request_Response.req_stmt_alloc(msg);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        handle = Request_Response.resp_stmt_alloc(recvMsg, stmt);
        return handle;
    }

    public static final int allocStmtHandleOnStandby(DmdbStatement_bs stmt) throws SQLException {
        int handle = 0;
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend msg = conn.getMsg();
        DmMsgRecv recvMsg = null;
        try {
            Request_Response.req_stmt_alloc(msg);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, 0);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        handle = Request_Response.resp_stmt_alloc(recvMsg, stmt);
        return handle;
    }

    public static final DmMsgRecv sendCurPosInfo(DmdbStatement_bs stmt, long curPos) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_execute_sendCurInfo(false, msg, stmt, curPos);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        Request_Response.resp_execute(recvMsg, stmt, false);
        return recvMsg;
    }

    public static final void closeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_close_stmt(msg, stmt.getHandle());
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        if (recvMsg != null) {
            Request_Response.resp_close_stmt(recvMsg, conn);
        }
    }

    public static final void freeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_stmt_free(msg, stmt.getHandle());
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        if (recvMsg != null) {
            Request_Response.resp_stmt_free(recvMsg, conn);
        }
    }

    public static final DmdbInfo prepareSQL(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag, int rwDestType) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmdbInfo dbInfo = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_prepare(msg, stmt, sql, direct, checkFlag);
            recvMsg = rwDestType == -1 ? DmdbCSI.accessToServer(msg, conn, stmt) : DmdbCSI.accessToServer(msg, conn, stmt, rwDestType);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        dbInfo = Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
        return dbInfo;
    }

    public static final DmdbInfo rePrepareOnPrimary(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag, DmMsgSend msg) throws SQLException, IOException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        Request_Response.req_prepare(msg, stmt, sql, direct, checkFlag);
        recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, 1);
        return Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
    }

    public static final DmdbInfo directExec_Opt(DmdbStatement_bs stmt, DmdbExecOpt execOpt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recv = null;
        DmdbInfo dbInfo = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_exec_direct(msg, stmt, execOpt);
            recv = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        dbInfo = Request_Response.resp_exec_direct(recv, stmt);
        return dbInfo;
    }

    public static final void commitWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_commit(msg);
            recvMsg = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        int sqlcode = Request_Response.resp_commit(recvMsg, conn);
        if (sqlcode >= 0 && holdability == 2) {
            conn.close_all_resultSet();
        }
    }

    public static final void rollbackWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_rollback(msg);
            recvMsg = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        int sqlcode = Request_Response.resp_rollback(recvMsg, conn);
        if (sqlcode >= 0 && holdability == 2) {
            conn.close_all_resultSet();
        }
    }

    private static void setParasMsg(PreExeced preExeced, DmMsgSend msg, DmdbStatement_bs stmt, int irow) throws SQLException {
        Request_Response.req_execute(preExeced, msg, stmt, stmt.cursorUpdateRow, irow);
    }

    private static int setBatchParasMsg(PreExeced preExeced, int startRow, DmMsgSend msg, DmdbPreparedStatement_bs stmt) throws SQLException {
        return Request_Response.req_execute_for_batch(preExeced, startRow, msg, stmt);
    }

    public static final DmdbInfo executePrepared(DmdbStatement_bs stmt, int irow) throws SQLException {
        DmMsgSend msg = stmt.getConnection_bs().getMsg();
        try {
            DmdbInfo dmdbInfo = DmdbCSI.executePrepared(new PreExeced(false), stmt, irow, msg);
            return dmdbInfo;
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
    }

    private static final DmdbInfo executePrepared(PreExeced preExeced, DmdbStatement_bs stmt, int irow, DmMsgSend msg) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recv = null;
        DmdbInfo dbInfo = null;
        DmdbCSI.setParasMsg(preExeced, msg, stmt, irow);
        recv = DmdbCSI.accessToServer(msg, conn, stmt);
        stmt.setPutLobData(1);
        dbInfo = DmdbCSI.getDescAndResultSet(stmt, recv);
        return dbInfo;
    }

    public static final int[] executePreparedBatch(DmdbPreparedStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        int batchSize = stmt.getBatchSize();
        int[] retArr = new int[batchSize];
        int[] retTmp = null;
        PreExeced preExeced = new PreExeced(false);
        DmMsgRecv recv = null;
        DmMsgSend msg = conn.getMsg();
        int startRow = 0;
        int nextRow = 0;
        int i = 0;
        while (i < batchSize) {
            retArr[i] = -2;
            ++i;
        }
        try {
            while (startRow < batchSize) {
                nextRow = DmdbCSI.setBatchParasMsg(preExeced, startRow, msg, stmt);
                if (nextRow != startRow && (retTmp = DmdbCSI.getBatchRowCounts(recv = DmdbCSI.accessToServer(msg, conn, stmt), stmt, nextRow - startRow)) != null) {
                    System.arraycopy(retTmp, 0, retArr, startRow, nextRow - startRow);
                }
                if (nextRow == batchSize) {
                    break;
                }
                DmdbInfo retdbInfo = DmdbCSI.executePrepared(preExeced, stmt, nextRow, msg);
                preExeced.setPreExeced(true);
                retArr[nextRow] = retdbInfo.getRowCount() > Integer.MAX_VALUE ? -2 : (int)retdbInfo.getRowCount();
                startRow = nextRow + 1;
            }
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return retArr;
    }

    public static final DmdbInfo getMoreResult(DmdbStatement_bs stmt, short resId) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recv = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_more_result(msg, stmt.getHandle(), resId);
            recv = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return DmdbCSI.getDescAndResultSet(stmt, recv);
    }

    private static DmdbInfo getDescAndResultSet(DmdbStatement_bs stmt, DmMsgRecv recv) throws SQLException {
        return Request_Response.resp_execute(recv, stmt, false);
    }

    public static final void putBlobData(DmdbPreparedStatement_bs stmt, int irow, int paramIndex, DmBinder binder) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        int retLen = 0;
        while (true) {
            blobMsg.resetCurNode();
            retLen = binder.bindLobCyc(blobMsg, irow, paramIndex);
            if (retLen == 0) break;
            DmdbCSI.putData(stmt, blobMsg, paramIndex, retLen);
        }
    }

    private static final void putData(DmdbStatement_bs stmt, DmMsgSend blobMsg, int paramIndex, int len) throws SQLException {
        DmMsgRecv recvMsg = null;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        Request_Response.req_put_data(stmt.getHandle(), blobMsg, paramIndex, len);
        recvMsg = DmdbCSI.accessToServer(blobMsg, conn, stmt);
        Request_Response.resp_put_data(recvMsg, conn);
    }

    public static final byte[] getBlobData(DmdbStatement_bs stmt, DmdbConnection_bs conn, DmdbLobLocator lobLocator, boolean fromStandby) throws SQLException {
        Vector<byte[]> vec = new Vector<byte[]>(10);
        boolean isOver = false;
        DmMsgRecv recvMsg = null;
        int cntHasGet = 0;
        DmMsgSend msg = conn.getMsg();
        try {
            while (!isOver) {
                Request_Response.req_get_data(msg, stmt.getHandle(), cntHasGet, lobLocator);
                recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
                isOver = Request_Response.resp_get_data(recvMsg, conn, lobLocator, cntHasGet);
                vec.add(lobLocator.m_dataOnceGet);
                cntHasGet += lobLocator.m_dataOnceGet.length;
            }
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        byte[] retData = new byte[cntHasGet];
        int tmp = 0;
        byte[] aBlockData = null;
        int i = 0;
        while (i < vec.size()) {
            aBlockData = (byte[])vec.get(i);
            System.arraycopy(aBlockData, 0, retData, tmp, aBlockData.length);
            tmp += aBlockData.length;
            ++i;
        }
        return retData;
    }

    public static final int fetch(DmdbStatement_bs stmt, long curPos, boolean fetchAll, DmdbResultSet_bs resultSet, short resId, boolean fromStandby) throws SQLException {
        int sqlcode = 0;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DataOfFetch dataOfFetch = new DataOfFetch(Long.MAX_VALUE, curPos, resId);
        DmMsgRecv recvMsg = null;
        byte[] buf = null;
        DmMsgSend msg = conn.getMsg();
        try {
            while (true) {
                Request_Response.req_fetch(msg, stmt.getHandle(), dataOfFetch);
                recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
                sqlcode = Request_Response.resp_fetch_checkErr(recvMsg, conn);
                if (sqlcode == -7036) {
                    if (resultSet != null) {
                        resultSet.rowCount = recvMsg.res_fetch_get_row_count();
                    }
                    break;
                }
                buf = Request_Response.resp_fetch_without_checkErr(recvMsg, dataOfFetch, resultSet, true);
                if (resultSet != null && resultSet.rowCount > 0L && (fetchAll ? (long)(resultSet.getRsCache().getRownum() + dataOfFetch.getResRetCnt()) == resultSet.rowCount : (long)dataOfFetch.getResRetCnt() == resultSet.rowCount)) break;
                if (sqlcode == 100) {
                    if (resultSet != null && resultSet.rowCount == Long.MAX_VALUE) {
                        resultSet.rowCount = dataOfFetch.getCurPos();
                    }
                    break;
                }
                if (!fetchAll) {
                    break;
                }
                if (buf == null) continue;
                resultSet.getRsCache().addBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            }
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        if (buf != null) {
            if (fetchAll) {
                resultSet.getRsCache().addBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            } else if (resultSet.multiRsCaches()) {
                DmdbResultSetCache tmp = stmt.getDmdbInfo().isBdtaRs() ? new DmdbResultSetCache_v(resultSet.getRsCache().getStatement(), resultSet.getRsCache().cols, -1) : new DmdbResultSetCache_h(resultSet.getRsCache().getStatement(), resultSet.getRsCache().cols);
                tmp.fillBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
                resultSet.addRsCache(tmp);
            } else {
                resultSet.getRsCache().fillBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            }
        }
        return sqlcode;
    }

    public static final void setCursorName(DmdbStatement_bs stmt, String cursorName) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_cursor_set_name(msg, conn.getServerEncoding(), stmt.getHandle(), cursorName);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        Request_Response.resp_cursor_set_name(recvMsg, conn);
    }

    public static final String getExplainInfo(DmdbStatement_bs stmt, String sqlToExplain) throws SQLException {
        if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!sqlToExplain.equalsIgnoreCase("show_pln_stat")) {
            sqlToExplain = "EXPLAIN " + sqlToExplain;
        }
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        String serverEncoding = conn.getServerEncoding();
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_prepare(msg, stmt, sqlToExplain, true, 0);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        DmdbInfo des = Request_Response.resp_prepare(recvMsg, serverEncoding, stmt, true);
        return des.getExplain();
    }

    public static final long blob_text_truncate(DmdbLob lob, byte flag, int length, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = lob.getConnection();
        DmMsgRecv recv = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_lob_truncate(msg, lob.getLobLocator(), length);
            recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return Request_Response.resp_lob_truncate(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final long lob_get_len(DmdbLob lob, boolean fromStandby) throws SQLException {
        DmMsgSend lobMsg = new DmMsgSend();
        DmMsgRecv recv = null;
        Request_Response.req_get_lob_len(lobMsg, lob.getLobLocator());
        recv = DmdbCSI.accessToServer(lobMsg, lob.getConnection(), null);
        return Request_Response.resp_get_lob_len(recv, lob);
    }

    public static final byte[] lob_get_bytes(DmdbLob lob, byte flag, int start_pos, int length, boolean fromStandby) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        DmMsgRecv recv = null;
        Request_Response.req_get_lob_data(blobMsg, lob.getLobLocator(), start_pos, length);
        recv = DmdbCSI.accessToServer(blobMsg, lob.getConnection(), null);
        return Request_Response.resp_get_lob_data(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final int lob_set_bytes(DmdbLob lob, byte flag, int start_pos, byte[] buf, int off, int len, byte firstOrLast, boolean fromStandby) throws SQLException {
        DmMsgRecv recv = null;
        DmMsgSend msg = lob.getConnection().getMsg();
        try {
            Request_Response.req_set_lob_data(msg, lob.getLobLocator(), start_pos, buf, off, len, firstOrLast);
            recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return Request_Response.resp_set_lob_data(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final String text_get_subString(DmdbLob lob, byte flag, int pos, int len, boolean fromStandby) throws SQLException {
        String str = null;
        byte[] bs = DmdbCSI.lob_get_bytes(lob, flag, pos, len, fromStandby);
        try {
            String serverEncoding = lob.getConnection().getServerEncoding();
            if (bs != null) {
                str = new String(bs, serverEncoding);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return str;
    }

    private static int[] getBatchRowCounts(DmMsgRecv recv, DmdbStatement_bs stmt, int size) throws SQLException {
        if (size == 1) {
            return DmdbCSI.getUnBatchRowCount(recv, stmt);
        }
        return Request_Response.resp_execute_for_batch(recv, stmt);
    }

    private static int[] getUnBatchRowCount(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        DmdbInfo dbinfo = Request_Response.resp_execute(recv, stmt, false);
        return new int[]{(int)dbinfo.getRowCount()};
    }

    public static final long getRowCount(DmdbStatement_bs stmt, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DataOfFetch dataFetch = new DataOfFetch(1L, Long.MAX_VALUE, 0);
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_fetch(msg, stmt.getHandle(), dataFetch);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        Request_Response.resp_fetch_checkErr(recvMsg, conn);
        Request_Response.resp_fetch_without_checkErr(recvMsg, dataFetch, null, false);
        return dataFetch.getResRowCnt();
    }

    public static final void preExec(DmdbStatement_bs stmt, int irow, DmBinder[] binders, boolean forBatch) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        DmMsgRecv recvMsg = null;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        Request_Response.req_pre_exec(stmt.getHandle(), blobMsg, irow, binders, forBatch);
        recvMsg = DmdbCSI.accessToServer(blobMsg, conn, stmt);
        Request_Response.resp_pre_exec(recvMsg, conn);
    }

    public static final void setSessionIsoLevel(int isoLevel, DmdbConnection_bs conn) throws SQLException {
        DmMsgRecv recv = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_sess_iso(msg, isoLevel);
            recv = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        Request_Response.resp_sess_iso(recv, conn);
    }

    public static final long[] table_ts(DmdbConnection_bs conn, long[] tbIds) throws SQLException {
        DmMsgRecv recv = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_table_ts(msg, tbIds);
            recv = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return Request_Response.resp_table_ts(recv, conn);
    }

    public static final synchronized int xa_process(DmdbConnection_bs conn, int xa_type, Xid xid, int flag) throws Exception {
        DmMsgRecv recvMsg = null;
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_xa_common(msg, xa_type, xid, flag);
            recvMsg = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return Request_Response.resp_xa_common(recvMsg);
    }

    public static final synchronized DmdbXid[] xa_recover(DmdbXAResource xaResource, int flag) throws Exception {
        DmMsgRecv recvMsg = null;
        DmdbConnection_bs conn = (DmdbConnection_bs)xaResource.getConnection();
        DmMsgSend msg = conn.getMsg();
        try {
            Request_Response.req_xa_common(msg, 5, null, flag);
            recvMsg = DmdbCSI.accessToServer(msg, conn, null);
        }
        finally {
            if (msg != null) {
                msg.releaseMsg();
            }
        }
        return Request_Response.resp_xa_recover(xaResource, recvMsg);
    }

    private static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        if (!conn.getRwSeparate()) {
            return DmdbSingleDistribute.accessToServer(msg, conn, stmt);
        }
        if (conn.isRwAutoDistribute()) {
            return DmdbRwAutoDistribute.accessToServer(msg, conn, stmt);
        }
        return DmdbRwUserDistribute.accessToServer(msg, conn, stmt);
    }

    private static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException {
        if (!conn.getRwSeparate()) {
            return DmdbSingleDistribute.accessToServer(msg, conn, stmt);
        }
        if (conn.isRwAutoDistribute()) {
            return DmdbRwAutoDistribute.accessToServer(msg, conn, stmt, rwDestType);
        }
        return DmdbRwUserDistribute.accessToServer(msg, conn, stmt, rwDestType);
    }
}

