/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DbAccessPure;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.IOException;
import java.net.SocketException;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.Properties;

public class DbAccess {
    ILogger LOG = LogFactory.getLog(DbAccess.class);
    private DbAccessPure m_accessPrimary = null;
    private DbAccessPure m_accessStandby = null;
    private boolean standbyAlive = false;
    private int latestRwDestType = 1;
    private long standbyRecoverTs = -1L;

    public DbAccess(String host, int port, Properties props, int connTimeout) throws IOException {
        this.m_accessPrimary = new DbAccessPure(host, port, props, connTimeout);
    }

    public DbAccessPure getAccessPrimary() {
        return this.m_accessPrimary;
    }

    public DbAccessPure getAccessStandby() {
        return this.m_accessStandby;
    }

    public void setAccessStandby(DbAccessPure standby) {
        this.m_accessStandby = standby;
    }

    public synchronized DmMsgRecv accessPrimary(DmMsgSend sendMsg, int compress) throws SQLException, IOException {
        this.LOG.debug((Object)this, "accessPrimary", Const.getCmdName(sendMsg.req_get_cmd()));
        this.setLatestRwDestType(1);
        DmMsgRecv recv = this.m_accessPrimary.access(sendMsg, compress);
        recv.setFromStandby(false);
        return recv;
    }

    public synchronized DmMsgRecv accessStandby(DmMsgSend sendMsg, int compress) throws SQLException, IOException {
        this.LOG.debug((Object)this, "accessStandby", Const.getCmdName(sendMsg.req_get_cmd()));
        this.setLatestRwDestType(0);
        DmMsgRecv recv = this.m_accessStandby.access(sendMsg, compress);
        recv.setFromStandby(true);
        return recv;
    }

    public void tryEnableSSL(boolean useSSLSocket, int rwDestType) throws IOException, SQLException {
        if (rwDestType == 1) {
            this.m_accessPrimary.tryEnableSSL(useSSLSocket);
        } else {
            this.m_accessStandby.tryEnableSSL(useSSLSocket);
        }
    }

    public AuthInfo getKerberosAuth(int rwDestType) {
        if (rwDestType == 1) {
            return this.m_accessPrimary.getAuthInfo();
        }
        return this.m_accessStandby.getAuthInfo();
    }

    public void removeStandby() {
        if (this.m_accessStandby != null) {
            this.m_accessStandby.close();
            this.m_accessStandby = null;
        }
        this.standbyAlive = false;
    }

    public void reset() throws SQLException {
        this.m_accessPrimary.reset();
        this.removeStandby();
    }

    public void close() {
        if (this.m_accessPrimary != null) {
            this.m_accessPrimary.close();
            this.m_accessPrimary = null;
        }
        this.removeStandby();
    }

    public AuthInfo initAuthInfo(String kerberosUser, String loginPath, int kerberosAuth, int rwDestType) throws SQLException {
        if (rwDestType == 1) {
            return this.m_accessPrimary.initAuthInfo(kerberosUser, loginPath, kerberosAuth);
        }
        return this.m_accessStandby.initAuthInfo(kerberosUser, loginPath, kerberosAuth);
    }

    public int getNetPacketSize() {
        return this.m_accessPrimary.getNetPacketSize();
    }

    public void setSoTimeout(int socketTimeout) throws SocketException {
        this.m_accessPrimary.getSocket().setSoTimeout(socketTimeout);
        if (this.m_accessStandby != null) {
            this.m_accessStandby.getSocket().setSoTimeout(socketTimeout);
        }
    }

    public byte[] getClientPubKey(int rwDestType) throws SQLException {
        if (rwDestType == 1) {
            return this.m_accessPrimary.getClientPubKey();
        }
        return this.m_accessStandby.getClientPubKey();
    }

    public PrivateKey getClientPrivKey(int rwDestType) throws SQLException {
        if (rwDestType == 1) {
            return this.m_accessPrimary.getClientPrivKey();
        }
        return this.m_accessStandby.getClientPrivKey();
    }

    public final void genMsgCiphers(int rwDestType, int msgCipherType, byte[] tempSessionKey, String CipherPath) throws SQLException {
        if (rwDestType == 1) {
            this.m_accessPrimary.genMsgCiphers(msgCipherType, tempSessionKey, CipherPath);
        } else {
            this.m_accessStandby.genMsgCiphers(msgCipherType, tempSessionKey, CipherPath);
        }
    }

    protected byte[] symmetricEncrypto(int rwDestType, byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        if (rwDestType == 1) {
            return this.m_accessPrimary.symmetricEncrypto(byteSource, length, gen_digest);
        }
        return this.m_accessStandby.symmetricEncrypto(byteSource, length, gen_digest);
    }

    public void setMsgEncryptType(int msgEncryptType, int rwDestType) {
        if (rwDestType == 1) {
            this.m_accessPrimary.setMsgEncryptType(msgEncryptType);
        } else {
            this.m_accessStandby.setMsgEncryptType(msgEncryptType);
        }
    }

    public void setHashType(int hashType, int rwDestType) throws SQLException {
        if (rwDestType == 1) {
            this.m_accessPrimary.setHashType(hashType);
        } else {
            this.m_accessStandby.setHashType(hashType);
        }
    }

    public boolean isStandbyAlive() {
        return this.m_accessStandby != null && this.standbyAlive;
    }

    public void setLatestRwDestType(int latestRwDestType) {
        this.latestRwDestType = latestRwDestType;
    }

    public int getLatestRwDestType() {
        return this.latestRwDestType;
    }

    public void setStandbyRecoverTs(long standbyRecoverTs) {
        this.standbyRecoverTs = standbyRecoverTs;
    }

    public long getStandbyRecoverTs() {
        return this.standbyRecoverTs;
    }

    public void setStandbyAlive(boolean standbyAlive) {
        this.standbyAlive = standbyAlive;
    }
}

