/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.BFileInner;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DmStringBinder
extends DmBinder {
    boolean new_lob_flag = false;
    private int m_strRealLen = 0;

    public DmStringBinder(DmdbPreparedStatement_bs pstmt, int prec) {
        super(pstmt);
        this.m_strRealLen = prec;
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 2;
        this.recPrec = 8188;
        this.recScale = 0;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = this.recScale;
            if (!forBatch && DmdbType.isNumberType(dType)) {
                this.destPrec = this.m_strRealLen < 8188 ? this.m_strRealLen : 8188;
            } else if (!forBatch && dType == 2) {
                this.destPrec = this.m_strRealLen < prec ? prec : this.m_strRealLen;
            }
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        byte[] ret = null;
        ret = this.diffParamObjectType && !(obj instanceof String) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.paramsDesc[icol].getTypeDescriptor()) : DmStringBinder.toDbBytes((String)obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz);
        if ((this.destDType == 12 || this.destDType == 19) && ret.length > 20480) {
            return -1;
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(String x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dtz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(x, destPrec, destDType, serverEncoding);
                break;
            }
            case 2: {
                if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
                    ret = Convertion.String_varchar_2CType(new BFileInner(x).toString(), destPrec, 2, serverEncoding);
                    break;
                }
                ret = Convertion.String_varchar_2CType(x, destPrec, destDType, serverEncoding);
                break;
            }
            case 18: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 17: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 12: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 19: {
                ret = Convertion.getBytes(x, serverEncoding);
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(Byte.parseByte(x.trim()));
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(Short.parseShort(x.trim()));
                break;
            }
            case 7: {
                ret = Convertion.intToByteArray(Integer.parseInt(x.trim()));
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(Long.parseLong(x.trim()));
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(Float.parseFloat(x.trim()));
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(Double.parseDouble(x.trim()));
                break;
            }
            case 9: {
                ret = Convertion.BigDecimalToByteArray(x, destPrec, destScale);
                break;
            }
            case 3: 
            case 13: {
                boolean b = false;
                if (x.equalsIgnoreCase("true")) {
                    b = true;
                } else if (x.equalsIgnoreCase("false")) {
                    b = false;
                } else {
                    try {
                        if (new BigDecimal(x).compareTo(new BigDecimal(0)) != 0) {
                            b = true;
                        }
                    }
                    catch (Exception e) {
                        DBError.throwSQLException(6007);
                    }
                }
                ret = Convertion.booleanToByteArray(b);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                ret = DmdbTimestamp.encodeByString(x, destDType, destScale, ltz, dtz);
                break;
            }
            case 21: {
                x = x.trim();
                if (x.length() <= 0) break;
                int secPrec = destScale & 0xF;
                int loadPrec = destScale >> 4 & 0xF;
                DmdbIntervalDT dt = new DmdbIntervalDT(x, loadPrec, secPrec);
                ret = Convertion.IntvDtToByteArray(dt, destScale);
                break;
            }
            case 20: {
                x = x.trim();
                if (x.length() <= 0) break;
                int loadPrec = destScale >> 4 & 0xF;
                DmdbIntervalYM ym = new DmdbIntervalYM(x, loadPrec);
                ret = Convertion.IntvYMToByteArray(ym, destScale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        int leftLen;
        String str = (String)this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        int maxLen = 8000;
        if (this.offset_var >= str.length()) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 0;
        }
        int readLen = (leftLen = str.length() - this.offset_var) < maxLen ? leftLen : maxLen;
        int endLen = this.offset_var + readLen;
        String subStr = str.substring(this.offset_var, endLen);
        this.offset_var += readLen;
        byte[] strbs = this.destDType == 12 || this.destDType == 17 || this.destDType == 18 ? Convertion.stringToBinary(subStr, this.destPrec) : Convertion.getBytes(subStr, serverEncoding);
        return lobMsg.appendOffRowBytes(strbs, 0, strbs.length, this.new_lob_flag, -1);
    }
}

