/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.binder.DmARRAYBinder;
import dm.jdbc.dataConvertion.binder.DmBigDecBinder;
import dm.jdbc.dataConvertion.binder.DmBooleanBinder;
import dm.jdbc.dataConvertion.binder.DmByteArrBinder;
import dm.jdbc.dataConvertion.binder.DmByteBinder;
import dm.jdbc.dataConvertion.binder.DmDateBinder;
import dm.jdbc.dataConvertion.binder.DmDmdbTimestampBinder;
import dm.jdbc.dataConvertion.binder.DmDoubleBinder;
import dm.jdbc.dataConvertion.binder.DmFloatBinder;
import dm.jdbc.dataConvertion.binder.DmIntBinder;
import dm.jdbc.dataConvertion.binder.DmIntvDTBinder;
import dm.jdbc.dataConvertion.binder.DmIntvYMBinder;
import dm.jdbc.dataConvertion.binder.DmLongBinder;
import dm.jdbc.dataConvertion.binder.DmOutParamBinder;
import dm.jdbc.dataConvertion.binder.DmSTRUCTBinder;
import dm.jdbc.dataConvertion.binder.DmShortBinder;
import dm.jdbc.dataConvertion.binder.DmStringBinder;
import dm.jdbc.dataConvertion.binder.DmTimeBinder;
import dm.jdbc.dataConvertion.binder.DmTimestampBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.ARRAY;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import dm.sql.STRUCT;
import dm.sql.TypeDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DmBinder {
    int recDType = 0;
    int recPrec = 0;
    int recScale = 0;
    byte destIoType = 0;
    int destDType = 0;
    int destPrec = 0;
    int destScale = 0;
    int srcScale = 0;
    byte[] streamReadTry = null;
    int streamReadTryLen = 0;
    boolean streamReadOver = false;
    char[] readerTry = null;
    int readerTryLen = 0;
    int offset_var = -1;
    public static final int RET_LOB_OFF_ROW = -1;
    public static final int RET_LOB_READ_OVER = 0;
    private int sqlType = 0;
    private boolean hasSqlType = false;
    private boolean hasSqlScale = false;
    private int sqlScale = -1;
    DmdbPreparedStatement_bs pstmt;
    ParameterDesc[] paramsDesc;
    boolean m_checkType = false;
    protected boolean diffParamObjectType = false;
    String serverEncoding;
    short dbTz;
    short ltz;
    Calendar defaultCalendar;

    public DmBinder(DmdbPreparedStatement_bs pstmt) {
        this.pstmt = pstmt;
        this.serverEncoding = pstmt.getConnection_bs().getServerEncoding();
        this.dbTz = pstmt.getConnection_bs().getDbTz();
        this.ltz = pstmt.getConnection_bs().getClientTz();
        this.defaultCalendar = Calendar.getInstance();
        this.init();
    }

    abstract void init();

    void clearVars() {
        this.streamReadTry = null;
        this.streamReadTryLen = 0;
        this.streamReadOver = false;
        this.readerTry = null;
        this.readerTryLen = 0;
        this.offset_var = -1;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = this.recScale;
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public abstract int bindData(DmMsgSend var1, int var2, int var3, boolean var4) throws SQLException;

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        throw new SQLException("Not impletement");
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
        this.setHasSqlType(true);
    }

    public void setSqlScale(int sqlScale) {
        this.sqlScale = sqlScale;
        this.setHasSqlScale(true);
    }

    public int bindDesc(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        this.checkType(irow, icol, forBatch);
        if (this.destIoType == 2 && 120 != this.destDType) {
            DmBinder inBinder = ((DmOutParamBinder)this).m_inParamBinder;
            inBinder.checkType(irow, icol, forBatch);
            this.destDType = inBinder.destDType;
            this.destPrec = inBinder.destPrec;
            this.destScale = inBinder.destScale;
            this.destIoType = inBinder.destIoType;
            this.srcScale = inBinder.srcScale;
        }
        if (this.destIoType == 1 && 120 == this.destDType) {
            msg.appendByte((byte)2);
        } else {
            msg.appendByte(this.destIoType);
        }
        msg.setInt(this.destDType);
        int lprec = 0;
        int lscale = 0;
        boolean isComplex = true;
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        switch (this.destDType) {
            case 117: 
            case 122: {
                lprec = TypeDescriptor.getPackArraySize(typeDesc);
                break;
            }
            case 121: {
                lprec = TypeDescriptor.getPackRecordSize(typeDesc);
                break;
            }
            case 119: {
                lprec = TypeDescriptor.getPackClassSize(typeDesc);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(this.paramsDesc[icol].getDType(), this.paramsDesc[icol].getScale())) {
                    lprec = this.paramsDesc[icol].getTypeDescriptor().getObjId();
                    if (lprec == 4) {
                        lprec = this.paramsDesc[icol].getTypeDescriptor().getOuterId();
                    }
                } else {
                    lprec = this.destPrec;
                }
                lscale = this.destScale;
                isComplex = false;
                break;
            }
            default: {
                lprec = this.destPrec;
                lscale = this.destScale;
                isComplex = false;
            }
        }
        msg.setInt(lprec);
        msg.setInt(lscale);
        switch (this.destDType) {
            case 117: 
            case 122: {
                TypeDescriptor.packArray(typeDesc, msg);
                break;
            }
            case 121: {
                TypeDescriptor.packRecord(typeDesc, msg);
                break;
            }
            case 119: {
                TypeDescriptor.packClass(typeDesc, msg);
                break;
            }
            default: {
                isComplex = false;
            }
        }
        if (isComplex) {
            return 13 + lprec;
        }
        return 13;
    }

    public boolean checkIOType(byte type) {
        return this.destIoType == type;
    }

    public byte[] castToDestType(Object x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, TypeDescriptor typeDesc) throws SQLException {
        if (x instanceof Boolean) {
            return DmBooleanBinder.toDbBytes((Boolean)x, destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof Byte) {
            return DmByteBinder.toDbBytes((Byte)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Short) {
            return DmShortBinder.toDbBytes((Short)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Integer) {
            return DmIntBinder.toDbBytes((Integer)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Long) {
            return DmLongBinder.toDbBytes((Long)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Float) {
            return DmFloatBinder.toDbBytes(((Float)x).floatValue(), destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof Double) {
            return DmDoubleBinder.toDbBytes((Double)x, destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof BigDecimal) {
            return DmBigDecBinder.toDbBytes((BigDecimal)x, destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof Date) {
            return DmDateBinder.toDbBytes((Date)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Timestamp) {
            return DmTimestampBinder.toDbBytes((Timestamp)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof Time) {
            return DmTimeBinder.toDbBytes((Time)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        }
        if (x instanceof DmdbTimestamp) {
            return DmDmdbTimestampBinder.toDbBytes((DmdbTimestamp)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz);
        }
        if (x instanceof DmdbIntervalDT) {
            return DmIntvDTBinder.toDbBytes((DmdbIntervalDT)x, destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof DmdbIntervalYM) {
            return DmIntvYMBinder.toDbBytes((DmdbIntervalYM)x, destDType, destPrec, destScale, serverEncoding);
        }
        if (x instanceof String) {
            return DmStringBinder.toDbBytes((String)x, destDType, destPrec, destScale, serverEncoding, ltz, dbTz);
        }
        if (x instanceof byte[]) {
            return DmByteArrBinder.toDbBytes((byte[])x, destDType, destPrec, destScale);
        }
        if (x instanceof ARRAY) {
            return DmARRAYBinder.toDbBytes((ARRAY)x, destDType, destPrec, destScale, typeDesc);
        }
        if (x instanceof STRUCT) {
            return DmSTRUCTBinder.toDbBytes((STRUCT)x, destDType, destPrec, destScale, typeDesc);
        }
        DBError.throwSQLException(6007);
        return null;
    }

    public void setInoutParamBinder(DmBinder inBinder) throws SQLException {
        throw new SQLException("setInoutParamBinder not impletement");
    }

    public DmdbStatement_bs getCursorStmt() throws SQLException {
        throw new SQLException("getCursorStmt not impletement");
    }

    public void clearRetValue() {
    }

    public void setHasSqlType(boolean hasSqlType) {
        this.hasSqlType = hasSqlType;
    }

    public boolean isHasSqlType() {
        return this.hasSqlType;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setHasSqlScale(boolean hasSqlScale) {
        this.hasSqlScale = hasSqlScale;
    }

    public boolean isHasSqlScale() {
        return this.hasSqlScale;
    }

    public int getSqlScale() {
        return this.sqlScale;
    }

    public boolean isDiffParamObjectType() {
        return this.diffParamObjectType;
    }

    public void setDiffParamObjectType(boolean diffParamObjectType) {
        this.diffParamObjectType = diffParamObjectType;
    }

    public int getRecDType() {
        return this.recDType;
    }

    public void setRecDType(int dtype) {
        this.recDType = dtype;
    }

    public int getRecPrec() {
        return this.recPrec;
    }

    public void setRecPrec(int recPrec) {
        this.recPrec = recPrec;
    }

    public int getRecScale() {
        return this.recScale;
    }

    public void setRecScale(int recScale) {
        this.recScale = recScale;
    }
}

