/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntAccessor
extends BaseAccessor {
    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return false;
        }
        return Convertion.fourByteToInt(this.byteValue) != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        int result = Convertion.fourByteToInt(this.byteValue);
        if (result < -128 || result > 127) {
            DBError.throwSQLException(6004);
        }
        return (byte)result;
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        int result = Convertion.fourByteToInt(this.byteValue);
        if (result < Short.MIN_VALUE || result > Short.MAX_VALUE) {
            DBError.throwSQLException(6004);
        }
        return (short)result;
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : Convertion.fourByteToInt(this.byteValue);
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : Convertion.fourByteToInt(this.byteValue);
    }

    @Override
    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : Convertion.fourByteToInt(this.byteValue);
    }

    @Override
    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : Convertion.fourByteToInt(this.byteValue);
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new BigDecimal(Convertion.fourByteToInt(this.byteValue));
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : String.valueOf(Convertion.fourByteToInt(this.byteValue));
    }

    @Override
    Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : Integer.valueOf(Convertion.fourByteToInt(this.byteValue));
    }
}

