/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.accessor.StringAccessor;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClobAccessor
extends StringAccessor {
    DmdbConnection_bs conn;
    LobDesc lobDesc;
    boolean lobReadOnly = true;

    protected ClobAccessor(DmdbConnection_bs conn, LobDesc lobDesc, boolean lobReadOnly) {
        this.conn = conn;
        this.lobDesc = lobDesc;
        this.lobReadOnly = lobReadOnly;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        Clob clob = this.getClob();
        if (this.wasNull) {
            return null;
        }
        return new DmdbInputStream(clob, this.serverEncoding);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        Clob clob = this.getClob();
        if (this.wasNull) {
            return null;
        }
        return new UtilBinaryToUnicodeInputStream(new DmdbInputStream(clob, this.serverEncoding));
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Clob clob = this.getClob();
        if (this.wasNull) {
            return null;
        }
        return new DmdbInputStream(clob, this.serverEncoding);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Clob clob1 = this.getClob();
        if (this.wasNull) {
            return null;
        }
        return clob1.getCharacterStream();
    }

    @Override
    public Clob getClob() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        return ClobAccessor.get_clob_value(this.byteValue, this.lobDesc, this.conn, !this.lobReadOnly);
    }

    @Override
    public String getString() throws SQLException {
        Clob clob = this.getClob();
        if (this.wasNull) {
            return null;
        }
        long length = clob.length();
        return clob.getSubString(1L, (int)length);
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        if ("LONGVARCHAR".equalsIgnoreCase(this.dTypeName)) {
            return this.getString();
        }
        return this.getClob();
    }

    public static DmdbClob get_clob_value(byte[] bs, LobDesc lobInfo, DmdbConnection_bs conn, boolean updAble) throws SQLException {
        DmdbClob ret = null;
        if (lobInfo != null) {
            ret = new DmdbClob(bs, lobInfo, conn, updAble);
            if (lobInfo.getLobMode() == 2 && ret != null && !ret.isValueInRow()) {
                int nblob_inrow_hdr_size = ret.nblob_inrow_hdr_size(conn.getNewLobFlag());
                byte[] tmp = ret.getBytesOffRow(1L, ret.getLobLen());
                byte[] value = new byte[nblob_inrow_hdr_size + tmp.length];
                System.arraycopy(ret.m_value, 0, value, 0, nblob_inrow_hdr_size);
                System.arraycopy(tmp, 0, value, nblob_inrow_hdr_size, tmp.length);
                ret.m_value = value;
            }
        } else {
            ret = new DmdbClob(bs, conn);
        }
        return ret;
    }
}

